package systemd

import (
	"context"

	"a.yandex-team.ru/infra/hostctl/internal/systemd/persist"
)

func NewShadowSystemctl(real Systemd, persist persist.Persist) Systemd {
	return &shadow{real: real, persist: persist}
}

type shadow struct {
	real    Systemd
	persist persist.Persist
}

func (s *shadow) Restart(ctx context.Context, u *Unit, revID string) error {
	return s.persist.SaveRevision(persistName(u), revID)
}

func (s *shadow) Reload(ctx context.Context, u *Unit, revID string) error {
	return s.persist.SaveRevision(persistName(u), revID)
}

func (s *shadow) Start(ctx context.Context, u *Unit, revID string) error {
	return s.persist.SaveRevision(persistName(u), revID)
}

func (s *shadow) Stop(ctx context.Context, u *Unit) error {
	return s.persist.RemoveRevision(persistName(u))
}

func (s *shadow) Enable(*Unit) error {
	return nil
}

func (s *shadow) Disable(*Unit) error {
	return nil
}

func (s *shadow) Status(unit *Unit, revID string) (*UnitStatus, error) {
	return s.real.Status(unit, revID)
}

func (s *shadow) ReloadDaemon() error {
	return nil
}
