package template

import (
	"a.yandex-team.ru/infra/hostctl/internal/engine/hostctx"
	pb "a.yandex-team.ru/infra/hostctl/proto"
)

// SimpleCompiledCtx implements CompiledCtx using old hostctx.Eval API
type SimpleCompiledCtx struct {
	ctxDef *CtxDefinition
}

func (c *SimpleCompiledCtx) Materialize(hi *pb.HostInfo) (MaterializedCtx, error) {
	v, err := hostctx.Eval(hi, c.ctxDef.Proto())
	if err != nil {
		return nil, err
	}
	return &materializedCtx{v: v}, nil
}

// SimpleCtxCompiler implements no-op compiler producing SimpleCompiledCtx instances which use old cel-go logic
type SimpleCtxCompiler struct {
}

// NewSimpleCtxCompiler constructs SimpleCtxCompiler instance
func NewSimpleCtxCompiler() *SimpleCtxCompiler {
	return &SimpleCtxCompiler{}
}

func (c *SimpleCtxCompiler) Compile(ctxDef *CtxDefinition) (CompiledCtx, error) {
	return &SimpleCompiledCtx{ctxDef: ctxDef}, nil
}
