package template

import (
	"io"

	"a.yandex-team.ru/infra/hostctl/internal/yamlutil"
	"a.yandex-team.ru/infra/hostctl/pkg/unitstorage"
	pb "a.yandex-team.ru/infra/hostctl/proto"
)

// ParseCtxDocument parses ctx part of Document and returns CtxDefinition (protobuf definition) of host context.
func ParseCtxDocument(document unitstorage.Document) (*CtxDefinition, error) {
	rv := &pb.Context{
		Vars: make([]*pb.Context_Var, 0),
	}
	ctxReader := document.CtxReader()
	// Fast path if we do not have any context
	if ctxReader == nil {
		return (*CtxDefinition)(rv), nil
	}
	buf, err := io.ReadAll(ctxReader)
	if err != nil {
		return nil, err
	}
	err = yamlutil.UnmarshalStrict(buf, rv)
	if err != nil {
		return nil, err
	}
	return (*CtxDefinition)(rv), nil
}
