package term

import (
	"a.yandex-team.ru/infra/hostctl/internal/color"
	"a.yandex-team.ru/infra/hostctl/internal/slot"
	"fmt"
	"google.golang.org/protobuf/encoding/protojson"
	"google.golang.org/protobuf/proto"
	"log"
)

var (
	errRed   = color.New(color.FgRed, color.Bold)
	pbFormat = protojson.MarshalOptions{
		Multiline:       true,
		Indent:          "  ",
		AllowPartial:    true,
		UseProtoNames:   false,
		UseEnumNumbers:  false,
		EmitUnpopulated: false,
		Resolver:        nil,
	}
)

func LogE(err error) {
	log.Println(errRed.Sprintf("Error: %s", err))
}

func FatalE(err error) {
	log.Fatalf(errRed.Sprintf("Error: %s", err))
}

func FatalF(format string, v ...interface{}) {
	log.Fatalf(errRed.Sprintf(format, v...))
}

func FmtVer(stage slot.Stage, ver, revID string) string {
	return fmt.Sprintf("(%s) %s (rev.%.11s)", stage, ver, revID)
}

func FmtProto(m proto.Message) string {
	return pbFormat.Format(m)
}
