package kind

import (
	"strings"
)

type Kind string

var (
	PortoDaemon     Kind = "PortoDaemon"
	PackageSet      Kind = "PackageSet"
	SystemService   Kind = "SystemService"
	TimerJob        Kind = "TimerJob"
	HostPod         Kind = "HostPod"
	HostPodFragment Kind = "HostPodFragment"

	Kinds = strings.Join([]string{
		string(PortoDaemon),
		string(PackageSet),
		string(SystemService),
		string(TimerJob),
		string(HostPod),
		string(HostPodFragment),
	}, ",")
)

func (k Kind) Kebab() string {
	switch k {
	case PackageSet:
		return "package-set"
	case PortoDaemon:
		return "porto-daemon"
	case SystemService:
		return "system-service"
	case TimerJob:
		return "timer-job"
	case HostPod:
		return "hostpod"
	}
	return ""
}
