package unit

import (
	"testing"

	"github.com/stretchr/testify/assert"

	pb "a.yandex-team.ru/infra/hostctl/proto"
)

func TestUnitPrettify(t *testing.T) {
	u := &Unit{
		revMeta: &pb.RevisionMeta{
			Version: "default",
			Kind:    "PackageSet",
		},
		slotMeta: &pb.SlotMeta{
			Annotations: map[string]string{
				"stage":    "stable",
				"filename": "/etc/hostman/units.d/test.yaml",
			},
		},
		spec: &pb.PackageSetSpec{
			Packages: []*pb.SystemPackage{{
				Name:    "p",
				Version: "1",
			}},
			Files: []*pb.ManagedFile{{
				Path:    "/a/b",
				Content: "content",
				User:    "root",
				Group:   "root",
				Mode:    "0644",
			}},
		}}
	got, err := u.Prettify()
	if err != nil {
		t.Error(err)
	}
	expected := `--------------------------------------------------------
---------------------- slot meta -----------------------
_kind: ""
annotations:
  filename: /etc/hostman/units.d/test.yaml
  stage: stable
labels: {}
skip_remove_phase: null
----------------------- rev meta -----------------------
kind: PackageSet
version: default
------------------------- spec -------------------------
files:
- content: content
  group: root
  mode: "0644"
  path: /a/b
  user: root
packages:
- name: p
  version: "1"
--------------------------------------------------------
`
	assert.Equal(t, expected, got)
}

func TestFmtRule(t *testing.T) {
	assert.Equal(t, "system-service-yandex-hm-server", FmtRule("SystemService", "yandex-hm-server"))
	assert.Equal(t, "timer-job-yandex-rtc-nodeinfo", FmtRule("TimerJob", "yandex-rtc-nodeinfo"))
	assert.Equal(t, "porto-daemon-juggler-client-rtc", FmtRule("PortoDaemon", "juggler-client-rtc"))
	assert.Equal(t, "package-set-upstream-packages", FmtRule("PackageSet", "upstream-packages"))
}
