package file

import "github.com/stretchr/testify/mock"

func NewFileMock() *fake {
	return &fake{}
}

type fake struct {
	mock.Mock
}

func (f *fake) Manage() error {
	args := f.Called()
	return args.Error(0)
}

func (f *fake) Remove() error {
	args := f.Called()
	return args.Error(0)
}

func (f *fake) Path() string {
	args := f.Called()
	return args.String(0)
}

func (f *fake) Content() string {
	args := f.Called()
	return args.String(0)
}

func (f *fake) User() string {
	args := f.Called()
	return args.String(0)
}

func (f *fake) Group() string {
	args := f.Called()
	return args.String(0)
}

func (f *fake) Mode() string {
	args := f.Called()
	return args.String(0)
}

func (f *fake) FromFs() (File, error) {
	args := f.Called()
	return args.Get(0).(File), args.Error(1)
}
