package file

func NewNoopFile(path, content, user, group, mode string) File {
	return &NoopFile{path, content, user, group, mode}
}

type NoopFile struct {
	path    string
	content string
	user    string
	group   string
	mode    string
}

func (*NoopFile) Manage() error {
	return nil
}
func (*NoopFile) Remove() error {
	return nil
}
func (f *NoopFile) Path() string {
	return f.path
}
func (f *NoopFile) Content() string {
	return f.content
}
func (f *NoopFile) User() string {
	return f.user
}
func (f *NoopFile) Group() string {
	return f.group
}
func (f *NoopFile) Mode() string {
	return f.mode
}
func (f *NoopFile) FromFs() (File, error) {
	return FromFs(NewNoopFile, f.Path())
}
