package dpkgutil

import (
	"io"
	"os"
)

// ReadStatus lookup by name.
func ReadStatus(name string) (*PackageStatus, error) {
	pkgs := map[string]*PackageStatus{name: {
		Installed: false,
		Name:      name,
		Version:   "unknown",
	}}
	err := ReadStatuses(pkgs)
	if err != nil {
		return nil, err
	}
	return pkgs[name], nil
}

// ReadStatuses returns requested packages which are in database.
func ReadStatuses(pkgs map[string]*PackageStatus) error {
	f, err := os.Open(Path)
	if err != nil {
		return err
	}
	return readStatuses(f, pkgs)
}

func readStatuses(r io.Reader, pkgs map[string]*PackageStatus) error {
	s := NewPackageScanner(r)
	for s.Scan() {
		p, err := s.Package()
		if err != nil {
			return err
		}
		if _, ok := pkgs[p.Name]; ok {
			// we receives pointer on reusing PackageStatus from scanner
			// and we need to copy package fields from this pointer
			pkgs[p.Name].CopyFrom(p)
		}
	}
	return nil
}
