package dpkgutil

import (
	"bufio"
	"bytes"
)

// we do not need other keys for PackageStatus
var knownKeys = []string{"Status", "Package", "Version"}
var knownKeysBytes = [][]byte{[]byte("Status"), []byte("Package"), []byte("Version")}

// Unmarshal lines with key values separated by ': '
func Unmarshal(b []byte, kv map[string]string) {
	s := bufio.NewScanner(bytes.NewBuffer(b))
	for s.Scan() {
		line := s.Bytes()
		// we want to skip redundant kv pairs
		if !knownKV(line) {
			continue
		}
		k, v := parseKeyValue(line)
		if k == "" || v == "" {
			continue
		}
		kv[k] = v
	}
}

func knownKV(line []byte) bool {
	known := false
	for _, key := range knownKeysBytes {
		if bytes.HasPrefix(line, key) {
			known = true
		}
	}
	return known
}

func parseKeyValue(kv []byte) (k string, v string) {
	i := bytes.Index(kv, []byte(": "))
	if i == -1 {
		return "", ""
	}
	return string(kv[:i]), string(kv[i+2:])
}
