package pacman

import (
	"a.yandex-team.ru/infra/hostctl/internal/units/env/pacman/dpkgutil"
	"github.com/stretchr/testify/mock"
)

func NewDPKGMock() *DPKGMock {
	return &DPKGMock{}
}

type DPKGMock struct {
	mock.Mock
}

func (m *DPKGMock) Update() error {
	args := m.Called()
	return args.Error(0)
}

func (m *DPKGMock) GetPackageStatus(name string) (*dpkgutil.PackageStatus, error) {
	args := m.Called(name)
	return args.Get(0).(*dpkgutil.PackageStatus), args.Error(1)
}

func (m *DPKGMock) Install(name, version string) (*dpkgutil.PackageStatus, error) {
	args := m.Called(name, version)
	return args.Get(0).(*dpkgutil.PackageStatus), args.Error(1)
}

func (m *DPKGMock) InstallDryRun(name, version string) (*dpkgutil.PackageStatus, error) {
	args := m.Called(name, version)
	return args.Get(0).(*dpkgutil.PackageStatus), args.Error(1)
}

func (m *DPKGMock) InstallSet(packageSet []Package) error {
	args := m.Called(packageSet)
	return args.Error(0)
}

func (m *DPKGMock) InstallSetDryRun(packageSet []Package) error {
	args := m.Called(packageSet)
	return args.Error(0)
}

func (m *DPKGMock) Purge(name string) error {
	args := m.Called(name)
	return args.Error(0)
}

func (m *DPKGMock) PurgeSet(names []string) error {
	args := m.Called(names)
	return args.Error(0)
}

func (m *DPKGMock) Repair() (bool, error) {
	args := m.Called()
	return args.Bool(0), args.Error(1)
}

func (m *DPKGMock) List(packages []string) (map[string]*dpkgutil.PackageStatus, error) {
	args := m.Called(packages)
	return args.Get(0).(map[string]*dpkgutil.PackageStatus), args.Error(1)
}
