package pacman

import "a.yandex-team.ru/infra/hostctl/internal/units/env/pacman/dpkgutil"

func NewNoop(dpkg PackageManager) PackageManager {
	return &NoopPacman{pacman: dpkg}
}

type NoopPacman struct {
	pacman PackageManager
}

func (p *NoopPacman) Update() error {
	return nil
}

func (p *NoopPacman) GetPackageStatus(name string) (*dpkgutil.PackageStatus, error) {
	return p.pacman.GetPackageStatus(name)
}

func (p *NoopPacman) List(packages []string) (map[string]*dpkgutil.PackageStatus, error) {
	return p.pacman.List(packages)
}

func (p *NoopPacman) Install(name, version string) (*dpkgutil.PackageStatus, error) {
	// apt install --dry-run for noop pacman
	return p.pacman.InstallDryRun(name, version)
}

func (p *NoopPacman) InstallDryRun(name, version string) (*dpkgutil.PackageStatus, error) {
	// apt install --dry-run for noop pacman
	return p.pacman.InstallDryRun(name, version)
}

func (p *NoopPacman) InstallSet(packages []Package) error {
	// apt install --dry-run for noop pacman
	return p.pacman.InstallSetDryRun(packages)
}

func (p *NoopPacman) InstallSetDryRun(packages []Package) error {
	// apt install --dry-run for noop pacman
	return p.pacman.InstallSetDryRun(packages)
}

func (p *NoopPacman) Purge(name string) error {
	return nil
}

func (p *NoopPacman) PurgeSet(names []string) error {
	return nil
}

func (p *NoopPacman) Repair() (bool, error) {
	return true, nil
}
