package porto

import (
	pb "a.yandex-team.ru/infra/hostctl/proto"
	"github.com/stretchr/testify/mock"
	"syscall"
	"time"
)

func NewFakePorto() *FakePorto {
	return &FakePorto{}
}

type FakePorto struct {
	mock.Mock
}

func (p *FakePorto) Start(name, etag string, props *pb.PortoProperties) error {
	args := p.Called(name, etag, props)
	return args.Error(0)
}

func (p *FakePorto) Kill(name string, signum syscall.Signal) error {
	args := p.Called(name, signum)
	return args.Error(0)
}

func (p *FakePorto) Destroy(name string) error {
	args := p.Called(name)
	return args.Error(0)
}

func (p *FakePorto) Get(name, prop string) (string, string, error) {
	args := p.Called(name, prop)
	return args.String(0), args.String(1), args.Error(2)
}

func (p *FakePorto) IsRunning(name string) (string, bool, error) {
	args := p.Called(name)
	return args.String(0), args.Bool(1), args.Error(2)
}

func (p *FakePorto) Status(name string) (*Status, error) {
	args := p.Called(name)
	return args.Get(0).(*Status), args.Error(1)
}

func (p *FakePorto) Disable(name string) error {
	args := p.Called(name)
	return args.Error(0)
}

func (p *FakePorto) WaitDead(name string, timeout time.Duration, timeFun func() time.Time) (bool, error) {
	args := p.Called(name, timeout, timeFun)
	return args.Bool(0), args.Error(1)
}
