package porto

import (
	pb "a.yandex-team.ru/infra/hostctl/proto"
	"syscall"
	"time"
)

func NewNoopPorto() Porto {
	return &noopPorto{NewProduction()}
}

type noopPorto struct {
	real Porto
}

func (n *noopPorto) Start(name, etag string, props *pb.PortoProperties) error {
	return nil
}

func (n *noopPorto) Kill(name string, signum syscall.Signal) error {
	return nil
}

func (n *noopPorto) Destroy(name string) error {
	return nil
}

func (n *noopPorto) Get(name, prop string) (string, string, error) {
	return n.real.Get(name, prop)
}

func (n *noopPorto) IsRunning(name string) (string, bool, error) {
	return n.real.IsRunning(name)
}

func (n *noopPorto) Status(name string) (*Status, error) {
	return n.real.Status(name)
}

func (n *noopPorto) Disable(name string) error {
	return nil
}

func (n *noopPorto) WaitDead(name string, timeout time.Duration, timeFun func() time.Time) (bool, error) {
	return true, nil
}
