package porto

import (
	"syscall"
	"time"

	pb "a.yandex-team.ru/infra/hostctl/proto"
)

type Porto interface {
	// Starts new container according to specified spec.
	// Fails if container already exists.
	Start(name, etag string, props *pb.PortoProperties) error
	// Sends specified signal to container.
	Kill(name string, signum syscall.Signal) error
	// Destroys container.
	Destroy(name string) error
	// Returns porto container named property.
	Get(name, prop string) (string, string, error)
	// Checks if container is running and returns current etag.
	IsRunning(name string) (string, bool, error)
	// Get container status and returns current etag.
	Status(name string) (*Status, error)
	// Disable service respawn by porto. Otherwise it will be restarted
	// after kill been sent.
	Disable(name string) error
	// Waits until container is dead by polling and sleeping.
	WaitDead(name string, timeout time.Duration, timeFun func() time.Time) (bool, error)
}

func etagFromPrivate(private string) string {
	return private[len(CookiePrefix)+1:]
}

func etagToPrivate(etag string) string {
	return CookiePrefix + ":" + etag
}
