package manager

import (
	"a.yandex-team.ru/infra/hostctl/internal/slot"
	"a.yandex-team.ru/infra/hostctl/internal/unit"
	"a.yandex-team.ru/infra/hostctl/internal/unit/kind"
	pb "a.yandex-team.ru/infra/hostctl/proto"
	"testing"
)

func Test_collectTransactionRevs(t *testing.T) {
	tests := []struct {
		name     string
		slots    map[string]slot.Slot
		incoming *unit.Unit
		want     map[string][]string
	}{{
		name: "applying new version",
		slots: map[string]slot.Slot{
			"apt": slot.NewSlot(&pb.Slot{
				Name:   "apt",
				Revs:   []*pb.Rev{{Id: "id1", Target: pb.RevisionTarget_CURRENT}},
				Status: &pb.SlotStatus{},
			}),
		},
		incoming: unit.NewTestUnit(&pb.PackageSetSpec{}, "id2", "apt", kind.PackageSet, nil, nil, false),
		want:     map[string][]string{"apt": {"id1", "id2"}},
	}, {
		name: "applying absent version",
		slots: map[string]slot.Slot{
			"apt": slot.NewSlot(&pb.Slot{
				Name:   "apt",
				Revs:   []*pb.Rev{{Id: "id1", Target: pb.RevisionTarget_CURRENT}},
				Status: &pb.SlotStatus{},
			}),
		},
		incoming: unit.NewTestUnit(&pb.PackageSetSpec{}, "id2", "apt", kind.PackageSet, nil, nil, true),
		want:     map[string][]string{"apt": {"id1"}},
	}, {
		name: "applying same version",
		slots: map[string]slot.Slot{
			"apt": slot.NewSlot(&pb.Slot{
				Name:   "apt",
				Revs:   []*pb.Rev{{Id: "id1", Target: pb.RevisionTarget_CURRENT}},
				Status: &pb.SlotStatus{},
			}),
		},
		incoming: unit.NewTestUnit(&pb.PackageSetSpec{}, "id1", "apt", kind.PackageSet, nil, nil, false),
		want:     map[string][]string{"apt": {"id1"}},
	}, {
		name: "do not panic on empty revisions",
		slots: map[string]slot.Slot{
			"apt": slot.NewSlot(&pb.Slot{
				Name:   "apt",
				Revs:   make([]*pb.Rev, 0),
				Status: &pb.SlotStatus{},
			}),
		},
		incoming: unit.NewTestUnit(&pb.PackageSetSpec{}, "id1", "apt", kind.PackageSet, nil, nil, true),
		want:     make(map[string][]string),
	}}
	for _, tt := range tests {
		t.Run(tt.name, func(t *testing.T) {
			got := collectTransactionRevs(tt.slots, tt.incoming)
			gotRevs := make(map[string][]string)
			for name, revs := range got {
				ids := make([]string, len(revs))
				for i := 0; i < len(revs); i++ {
					ids[i] = revs[i].ID()
				}
				gotRevs[name] = ids
			}
		})
	}
}
