package units

import (
	pb "a.yandex-team.ru/infra/hostctl/proto"
	"github.com/stretchr/testify/assert"
	"testing"
)

func Test_isRebooted(t *testing.T) {
	tests := []struct {
		name      string
		fromState string
		current   string
		want      bool
	}{{
		name:      "boot id changed",
		fromState: "4d35afa4-52e3-4d98-916d-173eaaa3e7b0",
		current:   "b0a1a0c1-373a-4ad4-8219-1ed4e0c1a431",
		want:      true,
	}, {
		name:      "boot id not changed",
		fromState: "4d35afa4-52e3-4d98-916d-173eaaa3e7b0",
		current:   "4d35afa4-52e3-4d98-916d-173eaaa3e7b0",
		want:      false,
	}, {
		name:      "state lose",
		fromState: "",
		current:   "4d35afa4-52e3-4d98-916d-173eaaa3e7b0",
		want:      false,
	}}
	for _, tt := range tests {
		t.Run(tt.name, func(t *testing.T) {
			got := isRebooted(tt.fromState, tt.current)
			assert.Equal(t, tt.want, got)
		})
	}
}

func Test_updateBootID(t *testing.T) {
	tests := []struct {
		name   string
		before *pb.HostctlState
		after  *pb.HostctlState
		bootID string
	}{{
		name:   "init on empty state",
		before: &pb.HostctlState{},
		after: &pb.HostctlState{
			Monitoring: &pb.HostctlState_Monitoring{BootId: "4d35afa4-52e3-4d98-916d-173eaaa3e7b0"},
		},
		bootID: "4d35afa4-52e3-4d98-916d-173eaaa3e7b0",
	}, {
		name: "not changed",
		before: &pb.HostctlState{
			Monitoring: &pb.HostctlState_Monitoring{BootId: "4d35afa4-52e3-4d98-916d-173eaaa3e7b0"},
		},
		after: &pb.HostctlState{
			Monitoring: &pb.HostctlState_Monitoring{BootId: "4d35afa4-52e3-4d98-916d-173eaaa3e7b0"},
		},
		bootID: "4d35afa4-52e3-4d98-916d-173eaaa3e7b0",
	}, {
		name: "changed",
		before: &pb.HostctlState{
			Monitoring: &pb.HostctlState_Monitoring{BootId: "b0a1a0c1-373a-4ad4-8219-1ed4e0c1a431"},
		},
		after: &pb.HostctlState{
			Monitoring: &pb.HostctlState_Monitoring{BootId: "4d35afa4-52e3-4d98-916d-173eaaa3e7b0"},
		},
		bootID: "4d35afa4-52e3-4d98-916d-173eaaa3e7b0",
	}}
	for _, tt := range tests {
		t.Run(tt.name, func(t *testing.T) {
			updateBootID(tt.before, tt.bootID)
			assert.Equal(t, tt.after, tt.before)
		})
	}
}
