package report

import (
	reporterpb "a.yandex-team.ru/infra/hmserver/proto"
	"a.yandex-team.ru/library/go/core/buildinfo"
	"github.com/golang/protobuf/ptypes"
	"github.com/stretchr/testify/assert"
	"testing"
	"time"
)

func Test_hmReporter_collectHostctl(t *testing.T) {
	info := buildinfo.BuildInfo{
		Date:        "2021-01-14T12:35:06.000000Z",
		SVNRevision: "7753188",
	}
	rs := &hmReporter{
		config: &Config{
			Hostname: "man1-3720.search.yandex.net",
		},
		ctype: "prestable",
	}
	lastTransition, _ := time.Parse(buildInfoTimeLayout, "2021-01-14T12:35:06")
	got := rs.collectHostctl(info)
	gotLastTransition, _ := ptypes.Timestamp(got.LastTransition)
	assert.Equal(t, "hostctl", got.Name)
	assert.Equal(t, info.SVNRevision, got.Version)
	assert.Equal(t, "Hostman", got.Kind)
	assert.Equal(t, reporterpb.Status_FALSE, got.Pending)
	assert.Equal(t, reporterpb.Status_TRUE, got.Ready)
	assert.Equal(t, rs.config.Hostname, got.Node)
	assert.Equal(t, "prestable", got.Stage)
	assert.Equal(t, lastTransition, gotLastTransition)
}
