package specutil

import (
	"time"

	pb "a.yandex-team.ru/infra/hostctl/proto"
)

const (
	defaultRetries int32 = 3
	defaultTimeout       = 10 * time.Second
)

type RetryPolicy struct {
	Timeout time.Duration
	Retries int32
}

func RetryPolicyFromUpdatePolicyOrDefaults(policy *pb.UpdatePolicy) RetryPolicy {
	rv := RetryPolicy{Timeout: defaultTimeout, Retries: defaultRetries}
	if policy != nil {
		if policy.Retries != 0 {
			rv.Retries = policy.Retries
		}
		if policy.Timeout != nil && policy.Timeout.AsDuration() != 0 {
			rv.Timeout = policy.Timeout.AsDuration()
		}
	}
	return rv
}

func TimeoutOrDefault(t time.Duration) time.Duration {
	if t == 0 {
		return defaultTimeout
	} else {
		return t
	}
}
