package specutil

import (
	"testing"
	"time"

	pb "a.yandex-team.ru/infra/hostctl/proto"
	"github.com/stretchr/testify/assert"
	"google.golang.org/protobuf/types/known/durationpb"
)

func TestTimeoutRetriesFromUpdatePolicyOrDefaults(t *testing.T) {
	rv := RetryPolicyFromUpdatePolicyOrDefaults(nil)
	if rv.Timeout != defaultTimeout || rv.Retries != defaultRetries {
		t.Errorf("default timeout or retries mismatch")
	}
	rv = RetryPolicyFromUpdatePolicyOrDefaults(&pb.UpdatePolicy{})
	if rv.Timeout != defaultTimeout || rv.Retries != defaultRetries {
		t.Errorf("default timeout or retries mismatch")
	}
	rv = RetryPolicyFromUpdatePolicyOrDefaults(&pb.UpdatePolicy{Timeout: durationpb.New(0), Retries: 0})
	if rv.Timeout != defaultTimeout || rv.Retries != defaultRetries {
		t.Errorf("default timeout or retries mismatch")
	}
	rv = RetryPolicyFromUpdatePolicyOrDefaults(&pb.UpdatePolicy{Timeout: durationpb.New(30 * time.Second), Retries: 0})
	if rv.Timeout != 30*time.Second {
		t.Errorf("timeout mismatch")
	}
	if rv.Retries != defaultRetries {
		t.Errorf("default retries mismatch")
	}
	rv = RetryPolicyFromUpdatePolicyOrDefaults(&pb.UpdatePolicy{Timeout: durationpb.New(30 * time.Second), Retries: 2})
	if rv.Timeout != 30*time.Second {
		t.Errorf("timeout mismatch")
	}
	if rv.Retries != 2 {
		t.Errorf("retries mismatch")
	}
}

func TestTimeoutOrDefault(t *testing.T) {
	assert.Equal(t, TimeoutOrDefault(0), defaultTimeout)
	assert.Equal(t, TimeoutOrDefault(time.Second), time.Second)
}
