package helper

import (
	"a.yandex-team.ru/infra/hostctl/internal/behaviortree"
	"a.yandex-team.ru/infra/hostctl/internal/changelog"
	"a.yandex-team.ru/infra/hostctl/internal/units/env"
	"time"
)

const warmupPeriod = 10 * time.Second

type NewWithEnv func(e *env.Env, ch *changelog.ChangeLog) behaviortree.Node

func Sleep() NewWithEnv {
	return SleepN(warmupPeriod)
}

func SleepN(period time.Duration) NewWithEnv {
	return func(e *env.Env, ch *changelog.ChangeLog) behaviortree.Node {
		return behaviortree.New(
			func(children []behaviortree.Node) (behaviortree.Status, error) {
				e.L.Debugf("Sleeping: %s", period)
				e.Sleep(period)
				return behaviortree.Success, nil
			},
		)
	}
}
