package tasks

import (
	"a.yandex-team.ru/infra/hostctl/internal/fmtutil"
	"fmt"
	"gopkg.in/yaml.v2"
	"strings"
)

type Plan []map[string]string

func (p Plan) Fmt(name, revID, desc string) (string, error) {
	b := &strings.Builder{}
	header := ""
	if len(revID) > 11 {
		header = fmt.Sprintf(" %s rev.%.11s (%s) ", name, revID, desc)
	}
	b.Write(fmtutil.FmtLine(header))
	b.WriteByte('\n')
	if len(p) == 0 {
		b.WriteString("**not** changed\n")
	} else {
		if err := yaml.NewEncoder(b).Encode(p); err != nil {
			return "", fmt.Errorf("failed to marshal plan: %w", err)
		}
	}
	b.Write(fmtutil.FmtLine(""))
	return b.String(), nil
}
