package tasks

import (
	"github.com/stretchr/testify/assert"
	"testing"
)

func TestPrettifyPlan(t *testing.T) {
	plan := make(Plan, 0)
	plan = append(plan, map[string]string{"package.install": "{ntp=1:4.2.8p4+dfsg-3ubuntu5.9, ntpdate=1:4.2.8p4+dfsg-3ubuntu5.9}"})
	name := "test"
	revID := "aaaaaaaaaaaaaaaaaa"
	desc := "current"
	got, err := plan.Fmt(name, revID, desc)
	if err != nil {
		t.Error(err)
	}
	expected := `------------ test rev.aaaaaaaaaaa (current) ------------
- package.install: '{ntp=1:4.2.8p4+dfsg-3ubuntu5.9, ntpdate=1:4.2.8p4+dfsg-3ubuntu5.9}'
--------------------------------------------------------`
	assert.Equal(t, expected, got)
}
