package portostates

import (
	"a.yandex-team.ru/infra/hostctl/internal/behaviortree"
	"a.yandex-team.ru/infra/hostctl/internal/changelog"
	"a.yandex-team.ru/infra/hostctl/internal/units/env"
	"fmt"
)

func TryDestroyContainer() NewPortoNode {
	return func(e *env.Env, ch *changelog.ChangeLog, c *Container) behaviortree.Node {
		return behaviortree.New(func(children []behaviortree.Node) (behaviortree.Status, error) {
			e.L.Infof("Destroying '%s'...", c.Name)
			err := e.Porto.Destroy(c.Name)
			if err != nil {
				err = fmt.Errorf("destroy(%s) failed: %w", c.Name, err)
				e.L.Error(err.Error())
				return behaviortree.Failure, err
			}
			ch.Add("porto.destroy", c.Name)
			return behaviortree.Success, nil
		})
	}
}
