package portostates

import (
	"a.yandex-team.ru/infra/hostctl/internal/behaviortree"
	"a.yandex-team.ru/infra/hostctl/internal/changelog"
	"a.yandex-team.ru/infra/hostctl/internal/units/env"
	"fmt"
)

func DisableContainer() NewPortoNode {
	return func(e *env.Env, ch *changelog.ChangeLog, c *Container) behaviortree.Node {
		return behaviortree.New(func(children []behaviortree.Node) (behaviortree.Status, error) {
			e.L.Infof("Disabling '%s' auto restarts...", c.Name)
			err := e.Porto.Disable(c.Name)
			if err != nil {
				err = fmt.Errorf("SetProperty(%s, respawn, false) failed: %w", c.Name, err)
				e.L.Error(err.Error())
				return behaviortree.Failure, err
			}
			ch.Add("porto.disable", c.Name)
			return behaviortree.Success, nil
		})
	}
}
