package portostates

import (
	"a.yandex-team.ru/infra/hostctl/internal/behaviortree"
	"a.yandex-team.ru/infra/hostctl/internal/changelog"
	"a.yandex-team.ru/infra/hostctl/internal/units/env"
	"a.yandex-team.ru/infra/hostctl/internal/units/env/porto"
	"fmt"
	"syscall"
	"time"
)

/*
                [->]
                  |
        v------------------v
[TryKillContainer] [WaitContainerDead]
*/
func KillContainer() NewPortoNode {
	return func(e *env.Env, ch *changelog.ChangeLog, c *Container) behaviortree.Node {
		return behaviortree.New(
			behaviortree.Sequence,
			TryKillContainer()(e, ch, c),
			WaitContainerDead()(e, c),
		)
	}
}

func TryKillContainer() NewPortoNode {
	return func(e *env.Env, ch *changelog.ChangeLog, c *Container) behaviortree.Node {
		return behaviortree.New(func(_ []behaviortree.Node) (behaviortree.Status, error) {
			e.L.Infof("Sending SIGTERM to '%s'...", c.Name)
			err := e.Porto.Kill(c.Name, syscall.SIGTERM)
			if err != nil {
				err = fmt.Errorf("kill (%s, TERM) failed: %w", c.Name, err)
				e.L.Error(err.Error())
				return behaviortree.Failure, err
			}
			ch.Add("porto.kill", c.Name)
			return behaviortree.Success, nil
		})
	}
}

func WaitContainerDead() StatusNode {
	return func(e *env.Env, c *Container) behaviortree.Node {
		return behaviortree.New(func(_ []behaviortree.Node) (behaviortree.Status, error) {
			//  Wait a bit for container to die
			e.L.Infof("Waiting '%s' to exit...", c.Name)
			dead, err := e.Porto.WaitDead(c.Name, porto.GraceShutdownPeriod, time.Now)
			if err != nil {
				err = fmt.Errorf("pool_wait(%s) failed: %w", c.Name, err)
				e.L.Error(err.Error())
				return behaviortree.Failure, err
			}
			if dead {
				e.L.Infof("%s shutdown gracefully", c.Name)
			} else {
				e.L.Infof("%s container did not shutdown gracefully", c.Name)
			}
			return behaviortree.Success, nil
		})
	}
}
