package portostates

import (
	"a.yandex-team.ru/infra/hostctl/internal/behaviortree"
	"a.yandex-team.ru/infra/hostctl/internal/changelog"
	"a.yandex-team.ru/infra/hostctl/internal/units/env"
	"a.yandex-team.ru/infra/hostctl/internal/units/tasks/helper"
)

/*
                                   [?]
                                    |
           v-----------------------------------------v
          [->]                               [(x3 retry) ->]
           |                                         |
       v---------------v            v---------v--------------v-----------v
[UpdateStatus] [ContainerUpToDate]  [?] [UpdateStatus] [StartContainer] [->]
                                     |                                   |
                         v-----------------v                v----------------v
                [ContainerUpToDate] [StopContainer]  [UpdateStatus] [ContainerUpToDate]
*/
func RunContainer() NewPortoNode {
	return func(e *env.Env, ch *changelog.ChangeLog, c *Container) behaviortree.Node {
		return behaviortree.New(
			behaviortree.Fallback,
			behaviortree.New(
				behaviortree.Sequence,
				UpdateStatus()(e, ch, c),
				ContainerUpToDate()(e, ch, c),
			),
			helper.WithRetry(behaviortree.New(
				behaviortree.Sequence,
				behaviortree.New(
					behaviortree.Fallback,
					ContainerUpToDate()(e, ch, c),
					StopContainer()(e, ch, c),
				),
				UpdateStatus()(e, ch, c),
				StartContainer()(e, ch, c),
				behaviortree.New(behaviortree.Sequence,
					UpdateStatus()(e, ch, c),
					ContainerUpToDate()(e, ch, c),
				),
			), "failed to start container after 3 attempts"),
		)
	}
}
