package portostates

import (
	"a.yandex-team.ru/infra/hostctl/internal/behaviortree"
	"a.yandex-team.ru/infra/hostctl/internal/changelog"
	"a.yandex-team.ru/infra/hostctl/internal/units/env"
)

/*
                                   [?]
                                    |
           v-----------------------------------------v
          [->]                                      [->]
           |                                         |
       v---------------v                      v-----------------v--------------v------------------v
[UpdateStatus] [ContainerNotRunning]  [DisableContainer] [StopContainer] [UpdateStatus] [ContainerNotRunning]
*/
func ShutdownContainer() NewPortoNode {
	return func(e *env.Env, ch *changelog.ChangeLog, c *Container) behaviortree.Node {
		return behaviortree.New(
			behaviortree.Fallback,
			behaviortree.New(
				behaviortree.Sequence,
				UpdateStatus()(e, ch, c),
				ContainerShutdowned()(e, c),
			),
			behaviortree.New(
				behaviortree.Sequence,
				DisableContainer()(e, ch, c),
				StopContainer()(e, ch, c),
				UpdateStatus()(e, ch, c),
				ContainerShutdowned()(e, c),
			),
		)
	}
}
