package portostates

import (
	"a.yandex-team.ru/infra/hostctl/internal/behaviortree"
	"a.yandex-team.ru/infra/hostctl/internal/changelog"
	"a.yandex-team.ru/infra/hostctl/internal/units/env"
	"a.yandex-team.ru/infra/hostctl/internal/units/tasks/helper"
)

/*
                   [?]
                    |
           v----------------v
   [ContainerRunning]      [->]
                            |
          v------------v-----------v----------------v
[TryStartContainer] [Sleep] [UpdateStatus] [ContainerRunning]
*/
func StartContainer() NewPortoNode {
	return func(e *env.Env, ch *changelog.ChangeLog, c *Container) behaviortree.Node {
		return behaviortree.New(
			behaviortree.Fallback,
			ContainerRunning()(e, c),
			behaviortree.New(
				behaviortree.Sequence,
				TryStartContainer()(e, ch, c),
				helper.Sleep()(e, ch),
				UpdateStatus()(e, ch, c),
				ContainerRunning()(e, c),
			),
		)
	}
}

func TryStartContainer() NewPortoNode {
	return func(e *env.Env, ch *changelog.ChangeLog, c *Container) behaviortree.Node {
		return behaviortree.New(func(children []behaviortree.Node) (behaviortree.Status, error) {
			e.L.Infof("Starting '%s' container...", c.Name)
			err := e.Porto.Start(c.Name, c.RevID, c.Props)
			if err != nil {
				e.L.Infof("Failed to start '%s' container: %s", c.Name, err.Error())
				return behaviortree.Failure, err
			}
			ch.Add("porto.start", c.Name)
			return behaviortree.Success, nil
		})
	}
}
