package portostates

import (
	"a.yandex-team.ru/infra/hostctl/internal/behaviortree"
	"a.yandex-team.ru/infra/hostctl/internal/changelog"
	"a.yandex-team.ru/infra/hostctl/internal/units/env"
	"a.yandex-team.ru/infra/hostctl/internal/units/tasks/helper"
)

/*
                        [?]
                         |
           v-------------------------v
   [ContainerNotRunning]            [->]
                                     |
                   v-----------------v---------------v
                 [->]          [UpdateStatus] [ContainerRunning]
                  |
       v----------------------v
[KillContainer] [TryDestroyContainer (x3 retry)]
*/
func StopContainer() NewPortoNode {
	return func(e *env.Env, ch *changelog.ChangeLog, c *Container) behaviortree.Node {
		return behaviortree.New(
			behaviortree.Fallback,
			ContainerShutdowned()(e, c),
			behaviortree.New(
				behaviortree.Sequence,
				behaviortree.New(
					behaviortree.Sequence,
					KillContainer()(e, ch, c),
					helper.WithRetry(TryDestroyContainer()(e, ch, c), "failed to destroy porto container in 3 attempts"),
				),
				UpdateStatus()(e, ch, c),
				ContainerShutdowned()(e, c),
			),
		)
	}
}
