package systemdstates

import (
	"a.yandex-team.ru/infra/hostctl/internal/behaviortree"
	"a.yandex-team.ru/infra/hostctl/internal/changelog"
	"a.yandex-team.ru/infra/hostctl/internal/systemd"
	"a.yandex-team.ru/infra/hostctl/internal/units/env"
)

type NewSystemdNode func(e *env.Env, ch *changelog.ChangeLog, u *systemd.Unit, revID string, status *systemd.UnitStatus) behaviortree.Node

type StatusNode func(e *env.Env, u *systemd.Unit, status *systemd.UnitStatus) behaviortree.Node

func UpdateStatus() NewSystemdNode {
	return func(e *env.Env, ch *changelog.ChangeLog, u *systemd.Unit, revID string, status *systemd.UnitStatus) behaviortree.Node {
		return behaviortree.New(func(_ []behaviortree.Node) (behaviortree.Status, error) {
			e.L.Infof("Updating status for: %s", u.FullName())
			s, err := e.Systemd.Status(u, revID)
			if err != nil {
				e.L.Errorf("Failed getting status for '%s': %s", u.FullName(), err)
				return behaviortree.Failure, err
			}
			status.CopyFrom(s)
			return behaviortree.Success, nil
		})
	}
}

var (
	NtpUnit             = systemd.ServiceUnit("ntp")
	ReloadOnEnableUnits = []*systemd.Unit{NtpUnit}
)
