package systemdstates

import (
	"a.yandex-team.ru/infra/hostctl/internal/behaviortree"
	"a.yandex-team.ru/infra/hostctl/internal/changelog"
	"a.yandex-team.ru/infra/hostctl/internal/systemd"
	"a.yandex-team.ru/infra/hostctl/internal/units/env"
)

/*
               [?]
      v-----------------v
[DaemonReloaded] [TryReloadDaemon]
*/
func ReloadDaemon() NewSystemdNode {
	return func(e *env.Env, ch *changelog.ChangeLog, u *systemd.Unit, revID string, status *systemd.UnitStatus) behaviortree.Node {
		return behaviortree.New(
			behaviortree.Fallback,
			DaemonReloaded()(e, ch, u, revID, status),
			TryReloadDaemon()(e, ch, u, revID, status),
		)
	}
}

func DaemonReloaded() NewSystemdNode {
	return func(e *env.Env, ch *changelog.ChangeLog, unit *systemd.Unit, revID string, status *systemd.UnitStatus) behaviortree.Node {
		return behaviortree.New(func(_ []behaviortree.Node) (behaviortree.Status, error) {
			e.L.Infof("Check daemon-reloaded NeedDaemonReload='%t'", status.NeedDaemonReload)
			if status.NeedDaemonReload {
				return behaviortree.Failure, nil
			}
			e.L.Infof("Check LoadState='%s', reload daemon if not 'loaded'", status.LoadState)
			if !status.LoadState.Loaded() {
				return behaviortree.Failure, nil
			}
			// reload daemon before enable/restart. to choose correct unit for enable/restart, not sysv
			if !status.Ok() {
				for _, u := range ReloadOnEnableUnits {
					if unit.FullName() == u.FullName() {
						return behaviortree.Failure, nil
					}
				}
			}
			return behaviortree.Success, nil
		})
	}
}

func TryReloadDaemon() NewSystemdNode {
	return func(e *env.Env, ch *changelog.ChangeLog, u *systemd.Unit, revID string, status *systemd.UnitStatus) behaviortree.Node {
		return behaviortree.New(func(_ []behaviortree.Node) (behaviortree.Status, error) {
			ch.Add("systemd.daemon-reload", "").Log(e.L)
			if err := e.Systemd.ReloadDaemon(); err != nil {
				e.L.Errorf("Failed to daemon-reload '%s': %s", u.FullName(), err)
				return behaviortree.Failure, err
			}
			return behaviortree.Success, nil
		})
	}
}
