package systemdstates

import (
	"a.yandex-team.ru/infra/hostctl/internal/behaviortree"
	"a.yandex-team.ru/infra/hostctl/internal/changelog"
	"a.yandex-team.ru/infra/hostctl/internal/systemd"
	"a.yandex-team.ru/infra/hostctl/internal/units/env"
)

/*
                [?]
      v--------------------v
[ServiceDisabled] [TryDisableService]
*/
func DisableService() NewSystemdNode {
	return func(e *env.Env, ch *changelog.ChangeLog, u *systemd.Unit, revID string, status *systemd.UnitStatus) behaviortree.Node {
		return behaviortree.New(
			behaviortree.Fallback,
			ServiceDisabled()(e, u, status),
			TryDisableService()(e, ch, u, revID, status),
		)
	}
}

func ServiceDisabled() StatusNode {
	return func(e *env.Env, u *systemd.Unit, status *systemd.UnitStatus) behaviortree.Node {
		return behaviortree.New(func(_ []behaviortree.Node) (behaviortree.Status, error) {
			e.L.Infof("Check service disabled UnitFileState='%s'", status.UnitFileState)
			if status.UnitFileState.Disabled() {
				return behaviortree.Success, nil
			}
			return behaviortree.Failure, nil
		})
	}
}

func TryDisableService() NewSystemdNode {
	return func(e *env.Env, ch *changelog.ChangeLog, u *systemd.Unit, revID string, status *systemd.UnitStatus) behaviortree.Node {
		return behaviortree.New(func(_ []behaviortree.Node) (behaviortree.Status, error) {
			ch.Add("systemd.disable", u.FullName()).Log(e.L)
			if err := e.Systemd.Disable(u); err != nil {
				e.L.Errorf("Failed to disable '%s': %s", u.FullName(), err)
				return behaviortree.Failure, err
			}
			return behaviortree.Success, nil
		})
	}
}
