package systemdstates

import (
	"a.yandex-team.ru/infra/hostctl/internal/behaviortree"
	"a.yandex-team.ru/infra/hostctl/internal/changelog"
	"a.yandex-team.ru/infra/hostctl/internal/systemd"
	"a.yandex-team.ru/infra/hostctl/internal/units/env"
)

/*
            [?]
      v-------------v
[ServiceEnabled] [TryEnableService]
*/
func EnableService() NewSystemdNode {
	return func(e *env.Env, ch *changelog.ChangeLog, u *systemd.Unit, revID string, status *systemd.UnitStatus) behaviortree.Node {
		return behaviortree.New(
			behaviortree.Fallback,
			ServiceEnabled()(e, ch, u, revID, status),
			TryEnableService()(e, ch, u, revID, status),
		)
	}
}

func ServiceEnabled() NewSystemdNode {
	return func(e *env.Env, ch *changelog.ChangeLog, u *systemd.Unit, revID string, status *systemd.UnitStatus) behaviortree.Node {
		return behaviortree.New(func(_ []behaviortree.Node) (behaviortree.Status, error) {
			e.L.Infof("Check service enabled UnitFileState='%s'", status.UnitFileState)
			if status.UnitFileState.Enabled() {
				return behaviortree.Success, nil
			}
			return behaviortree.Failure, nil
		})
	}
}

func TryEnableService() NewSystemdNode {
	return func(e *env.Env, ch *changelog.ChangeLog, u *systemd.Unit, revID string, status *systemd.UnitStatus) behaviortree.Node {
		return behaviortree.New(func(_ []behaviortree.Node) (behaviortree.Status, error) {
			ch.Add("systemd.enable", u.FullName()).Log(e.L)
			if err := e.Systemd.Enable(u); err != nil {
				e.L.Errorf("Failed to enable '%s': %s", u.FullName(), err)
				return behaviortree.Failure, err
			}
			return behaviortree.Success, nil
		})
	}
}
