package systemdstates

import (
	"time"

	"a.yandex-team.ru/infra/hostctl/internal/behaviortree"
	"a.yandex-team.ru/infra/hostctl/internal/changelog"
	"a.yandex-team.ru/infra/hostctl/internal/systemd"
	"a.yandex-team.ru/infra/hostctl/internal/units/env"
)

/*
                         [?]
              v------------------------|
             [->]                      v
      v--------------v                [->]
[UpdateStatus] [ServiceShutdowned]     |
      v------------v-------------v---------------v-----------v
[DisableService] [DeactivateService] [UpdateStatus] [ServiceShutdowned]
*/
func ShutdownSystemdService(timeout time.Duration) NewSystemdNode {
	return func(e *env.Env, ch *changelog.ChangeLog, u *systemd.Unit, revID string, status *systemd.UnitStatus) behaviortree.Node {
		return behaviortree.New(
			behaviortree.Fallback,
			behaviortree.New(
				behaviortree.Sequence,
				UpdateStatus()(e, ch, u, revID, status),
				ServiceShutdowned()(e, u, status),
			),
			behaviortree.New(
				behaviortree.Sequence,
				DisableService()(e, ch, u, revID, status),
				DeactivateService(timeout)(e, ch, u, revID, status),
				UpdateStatus()(e, ch, u, revID, status),
				ServiceShutdowned()(e, u, status),
			),
		)
	}
}

/*
                 [->]
         v------------------v
[ServiceDeactivated] [ServiceDisabled]
*/
func ServiceShutdowned() StatusNode {
	return func(e *env.Env, u *systemd.Unit, status *systemd.UnitStatus) behaviortree.Node {
		return behaviortree.New(
			behaviortree.Sequence,
			ServiceDeactivated()(e, u, status),
			ServiceDisabled()(e, u, status),
		)
	}
}
