package tasks

import (
	"a.yandex-team.ru/infra/hostctl/internal/changelog"
	"a.yandex-team.ru/infra/hostctl/internal/units/env"
)

type Task interface {
	Execute(e *env.Env, changelog *changelog.ChangeLog) error
	Plan(plan Plan) Plan
	Description() TaskKind
}

type TaskKind string

const (
	KindFileManage       TaskKind = "file.manage"
	KindFileRemove       TaskKind = "file.remove"
	KindPackageInstall   TaskKind = "pkg.install"
	KindPackageUninstall TaskKind = "pkg.uninstall"
	KindPortoRun         TaskKind = "porto.run"
	KindPortoShutdown    TaskKind = "porto.shutdown"
	KindSystemdRun       TaskKind = "systemd.run"
	KindSystemdShutdown  TaskKind = "systemd.shutdown"
)

const maxStateMachineOperationsCount = 15
