package yamlutil

import (
	"encoding/json"

	"google.golang.org/protobuf/encoding/protojson"
	"google.golang.org/protobuf/proto"
	"gopkg.in/yaml.v2"
)

var marshaller = protojson.MarshalOptions{
	EmitUnpopulated: true,
	UseProtoNames:   true,
}

func ProtoToYaml(m proto.Message) ([]byte, error) {
	buf, err := marshaller.Marshal(m)
	if err != nil {
		return nil, err
	}
	var messageInterface interface{}
	err = json.Unmarshal(buf, &messageInterface)
	if err != nil {
		return nil, err
	}
	yamlMessage, err := yaml.Marshal(messageInterface)
	if err != nil {
		return nil, err
	}
	return yamlMessage, nil
}
