package pbutil

import (
	pb "a.yandex-team.ru/infra/hostctl/proto"
	"crypto/sha1"
	"encoding/hex"
	"google.golang.org/protobuf/proto"
	"google.golang.org/protobuf/types/known/timestamppb"
)

var (
	marshallOptions = proto.MarshalOptions{Deterministic: true}
)

func setCondition(cond *pb.Condition, status, message string) {
	if cond.Status != status {
		cond.TransitionTime = timestamppb.Now()
	}
	cond.Status = status
	cond.Message = message
}

func FalseCond(cond *pb.Condition, message string) {
	setCondition(cond, "False", message)
}

func TrueCond(cond *pb.Condition, message string) {
	setCondition(cond, "True", message)
}

func UnknownCond(cond *pb.Condition, message string) {
	setCondition(cond, "Unknown", message)
}

func PbDigest(m proto.Message) (string, error) {
	buf, err := marshallOptions.Marshal(m)
	if err != nil {
		return "", err
	}
	h := sha1.New()
	if _, err = h.Write(buf); err != nil {
		return "", err
	}
	return hex.EncodeToString(h.Sum(nil)), nil
}
