package pbutil

import (
	"github.com/stretchr/testify/assert"
	"google.golang.org/protobuf/types/known/structpb"
	"testing"
)

func TestPbDigest(t *testing.T) {
	obj, err := structpb.NewValue(map[string]interface{}{
		"firstName": "John",
		"lastName":  "Smith",
		"age":       27,
		"spouse":    nil,
	})
	assert.NoError(t, err)
	buf, err := PbDigest(obj)
	assert.NoError(t, err)
	// Hardcoded value in case protobuf changes the way it serializes to bytes
	// as we heavily depend on it.
	assert.Equal(t, buf, "b5e64123c51e491762f947b50ef11f0d4a60ac2b")
}
