package proptest

import (
	"fmt"
	"math/rand"
)

func Check(gen func(r *rand.Rand) interface{}, actual, expected func(...interface{}) error) error {
	// persistence random source for reproducibility tests
	r := rand.New(rand.NewSource(1234))
	const testsCount = 1000
	errs := make([]string, 0)
	for i := 0; i < testsCount; i++ {
		m := gen(r)
		actualErr := actual(m)
		expectedErr := expected(m)
		if actualErr != nil && expectedErr != nil {
			if actualErr.Error() != expectedErr.Error() {
				errs = append(errs, fmt.Sprintf("different errors msgs actual:\n%s\n, expected:\n%s\n", actualErr, expectedErr))
			}
		}
		if actualErr != nil && expectedErr == nil {
			errs = append(errs, fmt.Sprintf("'%s' error returned but expected nil", actualErr))
		}
		if actualErr == nil && expectedErr != nil {
			errs = append(errs, fmt.Sprintf("'%s' error expected but was nil", expectedErr))
		}
	}
	if len(errs) > 0 {
		return fmt.Errorf("%s and other", errs[0])
	}
	return nil
}
