package bench

import (
	"a.yandex-team.ru/infra/hostctl/pkg/render"
	hostpb "a.yandex-team.ru/infra/hostctl/proto"
	"bytes"
	"github.com/stretchr/testify/assert"
	"testing"
)

func BenchmarkTemplateRenderer_Render(b *testing.B) {
	unitYaml := `vars:
  - name: stage
    match:
      - exp: "h(['man3-3998.search.yandex.net','man0-1000.search.yandex.net', 'sas1-7920.search.yandex.net'])"
        val: ebpf-demo
      - exp: "h(['vla0-1579.search.yandex.net', 'vla0-1582.search.yandex.net', 'vla0-1590.search.yandex.net', 'vla0-1594.search.yandex.net', 'vla0-1596.search.yandex.net', 'vla0-1597.search.yandex.net', 'vla0-1598.search.yandex.net', 'vla0-1604.search.yandex.net', 'vla0-1623.search.yandex.net', 'vla0-1628.search.yandex.net', 'vla0-1629.search.yandex.net', 'vla0-1635.search.yandex.net', 'vla0-1649.search.yandex.net', 'vla0-1651.search.yandex.net', 'vla0-1665.search.yandex.net', 'vla0-1676.search.yandex.net', 'vla0-1677.search.yandex.net', 'vla0-1681.search.yandex.net', 'vla0-1688.search.yandex.net', 'vla0-1693.search.yandex.net', 'vla0-1714.search.yandex.net', 'vla0-1718.search.yandex.net', 'vla0-1719.search.yandex.net', 'vla0-1723.search.yandex.net', 'vla0-1729.search.yandex.net', 'vla0-1757.search.yandex.net', 'vla0-1760.search.yandex.net', 'vla0-1762.search.yandex.net', 'vla0-1769.search.yandex.net', 'vla0-1770.search.yandex.net', 'vla0-1776.search.yandex.net', 'vla0-1787.search.yandex.net', 'vla0-1791.search.yandex.net', 'vla0-1800.search.yandex.net', 'vla0-1817.search.yandex.net', 'vla0-1831.search.yandex.net', 'vla0-1844.search.yandex.net', 'vla0-1846.search.yandex.net', 'vla0-1849.search.yandex.net', 'vla0-1851.search.yandex.net', 'vla0-1853.search.yandex.net', 'vla0-1868.search.yandex.net', 'vla0-1870.search.yandex.net', 'vla0-1885.search.yandex.net', 'vla0-1906.search.yandex.net', 'vla0-1908.search.yandex.net', 'vla0-1924.search.yandex.net', 'vla0-1929.search.yandex.net', 'vla0-1930.search.yandex.net', 'vla0-1955.search.yandex.net', 'vla0-1958.search.yandex.net', 'vla0-1966.search.yandex.net', 'vla0-1969.search.yandex.net', 'vla0-1980.search.yandex.net', 'vla0-2007.search.yandex.net', 'vla0-2019.search.yandex.net', 'vla0-2026.search.yandex.net', 'vla0-2031.search.yandex.net', 'vla0-2035.search.yandex.net', 'vla0-2042.search.yandex.net', 'vla0-2046.search.yandex.net', 'vla0-2058.search.yandex.net', 'vla0-2066.search.yandex.net', 'vla0-2071.search.yandex.net', 'vla0-2077.search.yandex.net', 'vla0-2082.search.yandex.net', 'vla0-2088.search.yandex.net', 'vla0-2091.search.yandex.net', 'vla0-2096.search.yandex.net', 'vla0-2097.search.yandex.net', 'vla0-2100.search.yandex.net', 'vla0-2125.search.yandex.net', 'vla0-2140.search.yandex.net', 'vla0-2155.search.yandex.net', 'vla0-2168.search.yandex.net', 'vla0-2170.search.yandex.net', 'vla0-2173.search.yandex.net', 'vla0-2199.search.yandex.net', 'vla0-2211.search.yandex.net', 'vla0-2216.search.yandex.net', 'vla0-2221.search.yandex.net', 'vla0-2229.search.yandex.net', 'vla0-2233.search.yandex.net', 'vla0-2245.search.yandex.net', 'vla0-2263.search.yandex.net', 'vla0-2267.search.yandex.net', 'vla0-2288.search.yandex.net', 'vla0-2292.search.yandex.net', 'vla0-2293.search.yandex.net', 'vla0-2314.search.yandex.net', 'vla0-2317.search.yandex.net', 'vla0-2328.search.yandex.net', 'vla0-2334.search.yandex.net', 'vla0-2339.search.yandex.net', 'vla0-2341.search.yandex.net', 'vla0-2409.search.yandex.net', 'vla0-2410.search.yandex.net', 'vla0-3155.search.yandex.net', 'vla0-3205.search.yandex.net', 'vla2-6754.search.yandex.net'])"
        val: KERNEL-519-exp
      - exp: "h(['sas0-5251.search.yandex.net', 'sas3-1513.search.yandex.net', 'sas3-1516.search.yandex.net', 'sas3-1518.search.yandex.net', 'sas3-1519.search.yandex.net', 'sas3-1520.search.yandex.net', 'sas3-1521.search.yandex.net', 'sas3-1531.search.yandex.net', 'sas3-1532.search.yandex.net', 'sas3-1540.search.yandex.net', 'sas3-1542.search.yandex.net', 'sas3-1549.search.yandex.net', 'vla0-5352.search.yandex.net', 'iva0-0289.search.yandex.net'])"
        val: RTCNETWORK-628-exp
      - exp: "h(['sas1-1497.search.yandex.net', 'sas3-4862.search.yandex.net', 'sas3-5089.search.yandex.net', 'sas3-5099.search.yandex.net', 'sas3-7556.search.yandex.net', 'vla0-6800.search.yandex.net', 'vla0-7784.search.yandex.net', 'vla2-3879.search.yandex.net', 'vla3-1305.search.yandex.net', 'vla3-1622.search.yandex.net'])"
        val: RTCNETWORK-699-exp
      - exp: "h(['sas3-7220.search.yandex.net', 'sas3-7126.search.yandex.net', 'sas3-7384.search.yandex.net', 'sas3-7194.search.yandex.net', 'sas2-8554.search.yandex.net', 'sas2-2143.search.yandex.net', 'sas3-2895.search.yandex.net', 'sas3-5363.search.yandex.net', 'sas3-5401.search.yandex.net', 'sas3-7219.search.yandex.net'])"
        val: RTCNETWORK-763-exp
      - exp: "h(['vla0-8307.search.yandex.net', 'vla0-8308.search.yandex.net', 'vla0-8309.search.yandex.net', 'vla0-8310.search.yandex.net', 'vla0-8311.search.yandex.net', 'vla0-8312.search.yandex.net', 'vla0-8313.search.yandex.net', 'vla0-8314.search.yandex.net', 'vla0-8315.search.yandex.net', 'vla0-8316.search.yandex.net', 'vla0-8317.search.yandex.net', 'vla0-8318.search.yandex.net', 'vla0-8319.search.yandex.net', 'vla0-8320.search.yandex.net', 'vla0-8321.search.yandex.net', 'vla0-8435.search.yandex.net', 'vla0-8436.search.yandex.net', 'vla0-8437.search.yandex.net', 'vla0-8438.search.yandex.net', 'vla0-8439.search.yandex.net', 'vla0-8441.search.yandex.net', 'vla0-8442.search.yandex.net', 'vla0-8443.search.yandex.net', 'vla0-8444.search.yandex.net', 'vla0-8445.search.yandex.net', 'vla0-8446.search.yandex.net', 'vla0-8447.search.yandex.net', 'vla0-8448.search.yandex.net', 'vla0-8449.search.yandex.net', 'vla0-8450.search.yandex.net'])"
        val: RUNTIMECLOUD-18353-exp
      - exp: "h(['vla0-7276.search.yandex.net', 'vla0-4544.search.yandex.net', 'vla0-4526.search.yandex.net', 'vla0-4547.search.yandex.net', 'vla0-8780.search.yandex.net', 'vla0-4549.search.yandex.net', 'vla0-5338.search.yandex.net', 'vla0-5341.search.yandex.net', 'vla0-4535.search.yandex.net', 'vla0-5349.search.yandex.net', 'vla0-4534.search.yandex.net', 'vla0-7646.search.yandex.net', 'vla0-6046.search.yandex.net', 'vla0-4529.search.yandex.net', 'vla0-4530.search.yandex.net', 'vla0-4470.search.yandex.net', 'vla0-5434.search.yandex.net', 'vla0-4546.search.yandex.net', 'vla0-5421.search.yandex.net', 'vla0-5342.search.yandex.net', 'vla0-7340.search.yandex.net', 'vla0-7656.search.yandex.net', 'vla3-1973.search.yandex.net', 'vla0-4466.search.yandex.net', 'vla0-5344.search.yandex.net', 'vla0-7657.search.yandex.net', 'vla0-5348.search.yandex.net', 'vla0-5433.search.yandex.net', 'vla0-4468.search.yandex.net', 'vla0-4545.search.yandex.net', 'vla3-1879.search.yandex.net', 'vla3-1881.search.yandex.net', 'vla0-7973.search.yandex.net', 'vla0-4558.search.yandex.net', 'vla1-2869.search.yandex.net', 'vla0-5350.search.yandex.net', 'vla0-7341.search.yandex.net', 'vla0-7974.search.yandex.net', 'sas6-2272.search.yandex.net', 'sas0-6500.search.yandex.net', 'sas0-4255.search.yandex.net', 'sas0-6499.search.yandex.net', 'sas0-6495.search.yandex.net', 'sas0-6492.search.yandex.net', 'sas0-4257.search.yandex.net', 'sas0-5267.search.yandex.net', 'sas5-7845.search.yandex.net', 'sas2-4949.search.yandex.net', 'sas0-4284.search.yandex.net', 'sas0-6517.search.yandex.net', 'sas0-6506.search.yandex.net', 'sas0-6566.search.yandex.net', 'sas0-6494.search.yandex.net', 'sas0-6487.search.yandex.net', 'sas0-5259.search.yandex.net', 'sas0-6617.search.yandex.net', 'sas0-6616.search.yandex.net', 'sas2-1766.search.yandex.net', 'sas6-0569.search.yandex.net', 'sas1-0012.search.yandex.net', 'sas0-7992.search.yandex.net', 'sas0-6491.search.yandex.net', 'sas2-1180.search.yandex.net', 'sas0-5225.search.yandex.net', 'sas0-4259.search.yandex.net', 'sas0-6565.search.yandex.net', 'sas0-8959.search.yandex.net', 'sas1-0393.search.yandex.net', 'sas6-2274.search.yandex.net', 'sas0-6673.search.yandex.net', 'sas0-6488.search.yandex.net', 'sas0-5224.search.yandex.net', 'sas0-5190.search.yandex.net', 'sas0-5269.search.yandex.net', 'sas6-2273.search.yandex.net', 'sas3-1107.search.yandex.net', 'sas0-3827.search.yandex.net', 'sas0-5263.search.yandex.net', 'sas0-5266.search.yandex.net', 'sas3-4311.search.yandex.net', 'sas0-4258.search.yandex.net', 'sas2-4992.search.yandex.net', 'sas5-9589.search.yandex.net', 'sas2-1762.search.yandex.net', 'sas0-4256.search.yandex.net', 'sas2-4947.search.yandex.net', 'sas0-5262.search.yandex.net', 'sas0-6490.search.yandex.net', 'sas6-0570.search.yandex.net', 'sas0-5226.search.yandex.net', 'sas0-7993.search.yandex.net', 'sas0-6497.search.yandex.net', 'sas5-9588.search.yandex.net', 'sas0-7990.search.yandex.net', 'sas0-5264.search.yandex.net', 'sas3-4499.search.yandex.net', 'sas6-2275.search.yandex.net', 'sas2-4948.search.yandex.net', 'sas2-4946.search.yandex.net', 'sas0-6486.search.yandex.net', 'sas0-5268.search.yandex.net', 'sas0-5261.search.yandex.net', 'sas0-5265.search.yandex.net', 'sas0-5260.search.yandex.net', 'sas3-1410.search.yandex.net', 'sas6-2434.search.yandex.net', 'sas3-1108.search.yandex.net', 'sas0-6489.search.yandex.net', 'sas0-5227.search.yandex.net', 'man0-3046.search.yandex.net', 'man0-0337.search.yandex.net', 'man0-0340.search.yandex.net', 'iva0-1114.search.yandex.net', 'iva0-0325.search.yandex.net', 'iva0-0324.search.yandex.net', 'vla0-7338.search.yandex.net', 'vla0-5351.search.yandex.net', 'vla0-5343.search.yandex.net', 'sas3-1515.search.yandex.net', 'sas2-8457.search.yandex.net', 'sas2-8461.search.yandex.net', 'sas2-8462.search.yandex.net', 'sas2-8463.search.yandex.net', 'sas2-8465.search.yandex.net', 'sas2-8466.search.yandex.net', 'iva1-1138.search.yandex.net', 'sas3-0154.search.yandex.net', 'sas3-0275.search.yandex.net', 'sas4-3442.search.yandex.net', 'vla2-8756.search.yandex.net', 'iva1-0932.search.yandex.net', 'iva1-1126.search.yandex.net', 'iva1-1137.search.yandex.net', 'iva1-0997.search.yandex.net', 'iva1-1127.search.yandex.net', 'iva1-1140.search.yandex.net', 'iva1-1130.search.yandex.net', 'iva1-7085.search.yandex.net', 'iva1-0998.search.yandex.net', 'iva1-0942.search.yandex.net', 'iva1-0021.search.yandex.net', 'iva1-0230.search.yandex.net', 'iva1-0933.search.yandex.net', 'iva1-1129.search.yandex.net', 'iva1-0843.search.yandex.net', 'iva1-1229.search.yandex.net', 'iva1-1139.search.yandex.net', 'iva1-1143.search.yandex.net', 'iva1-7082.search.yandex.net', 'iva1-0930.search.yandex.net', 'iva1-0842.search.yandex.net', 'iva1-0919.search.yandex.net', 'iva1-1124.search.yandex.net', 'iva1-0929.search.yandex.net', 'iva0-0286.search.yandex.net', 'iva1-1128.search.yandex.net', 'iva1-1231.search.yandex.net', 'iva1-1232.search.yandex.net', 'iva1-7083.search.yandex.net', 'iva1-0255.search.yandex.net', 'iva1-1142.search.yandex.net', 'iva1-1230.search.yandex.net', 'iva1-1131.search.yandex.net', 'iva0-0300.search.yandex.net', 'iva1-7084.search.yandex.net', 'iva1-0949.search.yandex.net', 'iva1-1021.search.yandex.net', 'iva1-1136.search.yandex.net', 'iva1-0935.search.yandex.net', 'iva1-1132.search.yandex.net', 'iva1-1134.search.yandex.net', 'iva0-0292.search.yandex.net', 'iva1-0915.search.yandex.net', 'iva1-1141.search.yandex.net', 'iva1-1144.search.yandex.net', 'iva0-0288.search.yandex.net', 'iva0-0287.search.yandex.net', 'iva0-0291.search.yandex.net', 'iva1-0926.search.yandex.net', 'iva1-0938.search.yandex.net', 'iva1-1025.search.yandex.net', 'iva1-1228.search.yandex.net', 'iva1-0911.search.yandex.net', 'iva1-8347.search.yandex.net', 'iva0-0298.search.yandex.net', 'iva1-1234.search.yandex.net', 'iva1-0937.search.yandex.net', 'iva1-0945.search.yandex.net', 'iva1-1233.search.yandex.net', 'vla1-0913.search.yandex.net', 'vla2-5914.search.yandex.net', 'vla0-2371.search.yandex.net', 'vla2-5909.search.yandex.net', 'vla2-5609.search.yandex.net', 'vla2-5620.search.yandex.net', 'vla2-5607.search.yandex.net', 'vla0-6853.search.yandex.net', 'vla1-0942.search.yandex.net', 'vla2-5610.search.yandex.net', 'vla2-5600.search.yandex.net', 'vla2-5915.search.yandex.net', 'vla1-0890.search.yandex.net', 'vla0-2369.search.yandex.net', 'vla2-5910.search.yandex.net', 'vla0-2366.search.yandex.net', 'vla2-5605.search.yandex.net', 'vla2-5601.search.yandex.net', 'vla1-0920.search.yandex.net', 'vla2-5598.search.yandex.net', 'vla2-5911.search.yandex.net', 'vla0-2367.search.yandex.net', 'vla0-2370.search.yandex.net', 'vla2-5617.search.yandex.net', 'vla0-4552.search.yandex.net', 'vla2-5615.search.yandex.net', 'vla0-2372.search.yandex.net', 'vla2-5606.search.yandex.net', 'vla2-5616.search.yandex.net', 'vla0-2368.search.yandex.net', 'vla0-2365.search.yandex.net', 'vla1-0895.search.yandex.net', 'vla2-5613.search.yandex.net', 'vla1-0947.search.yandex.net', 'vla2-5611.search.yandex.net', 'vla2-5908.search.yandex.net', 'vla2-5920.search.yandex.net', 'vla0-4550.search.yandex.net', 'vla2-5618.search.yandex.net', 'vla2-5608.search.yandex.net', 'vla1-0912.search.yandex.net', 'vla0-4551.search.yandex.net', 'vla0-6852.search.yandex.net', 'vla2-5602.search.yandex.net', 'vla2-5913.search.yandex.net', 'vla1-0898.search.yandex.net', 'vla2-5603.search.yandex.net', 'sas2-8193.search.yandex.net', 'sas3-3500.search.yandex.net', 'sas3-1527.search.yandex.net', 'sas3-1535.search.yandex.net', 'sas0-6379.search.yandex.net', 'sas3-0116.search.yandex.net', 'sas0-5241.search.yandex.net', 'sas0-6134.search.yandex.net', 'sas5-7488.search.yandex.net', 'sas0-6376.search.yandex.net', 'sas1-9905.search.yandex.net', 'sas3-0120.search.yandex.net', 'sas3-0123.search.yandex.net', 'sas3-0286.search.yandex.net', 'sas0-5240.search.yandex.net', 'sas1-9876.search.yandex.net', 'sas0-6568.search.yandex.net', 'sas4-8706.search.yandex.net', 'sas0-6480.search.yandex.net', 'sas0-5239.search.yandex.net', 'sas1-9943.search.yandex.net', 'sas1-9961.search.yandex.net', 'sas3-1537.search.yandex.net', 'sas0-6386.search.yandex.net', 'sas5-2000.search.yandex.net', 'sas0-5253.search.yandex.net', 'sas5-1779.search.yandex.net', 'sas0-5243.search.yandex.net', 'sas4-8704.search.yandex.net', 'sas0-6378.search.yandex.net', 'sas0-5232.search.yandex.net', 'sas2-8469.search.yandex.net', 'sas1-9900.search.yandex.net', 'sas3-1130.search.yandex.net', 'sas0-6481.search.yandex.net', 'sas0-6387.search.yandex.net', 'sas4-3441.search.yandex.net', 'sas0-5236.search.yandex.net', 'sas0-5249.search.yandex.net', 'sas1-9908.search.yandex.net', 'sas1-9941.search.yandex.net', 'sas3-0280.search.yandex.net', 'sas3-1550.search.yandex.net', 'sas1-9861.search.yandex.net', 'sas4-3438.search.yandex.net', 'sas1-9953.search.yandex.net', 'sas0-6137.search.yandex.net', 'sas3-8526.search.yandex.net', 'sas0-5248.search.yandex.net', 'sas0-6384.search.yandex.net', 'sas3-3498.search.yandex.net', 'sas0-5252.search.yandex.net', 'sas3-0271.search.yandex.net', 'sas5-2001.search.yandex.net', 'sas0-5233.search.yandex.net', 'sas0-5238.search.yandex.net', 'sas3-2141.search.yandex.net', 'sas3-3501.search.yandex.net', 'sas3-0126.search.yandex.net', 'sas3-0285.search.yandex.net', 'sas3-1528.search.yandex.net', 'sas0-5255.search.yandex.net', 'sas3-2197.search.yandex.net', 'sas3-0272.search.yandex.net', 'sas3-1133.search.yandex.net', 'sas0-5244.search.yandex.net', 'sas1-9864.search.yandex.net', 'sas5-7489.search.yandex.net', 'sas0-5234.search.yandex.net', 'sas3-1517.search.yandex.net', 'sas2-8192.search.yandex.net', 'sas1-9859.search.yandex.net', 'sas0-6380.search.yandex.net', 'sas0-6388.search.yandex.net', 'sas3-1510.search.yandex.net', 'sas3-1548.search.yandex.net', 'sas3-1129.search.yandex.net', 'sas0-6570.search.yandex.net', 'sas3-0155.search.yandex.net', 'sas3-1524.search.yandex.net', 'sas3-0125.search.yandex.net', 'sas3-1536.search.yandex.net', 'sas0-6136.search.yandex.net', 'sas3-0115.search.yandex.net', 'sas0-5250.search.yandex.net', 'sas2-9407.search.yandex.net', 'sas0-5254.search.yandex.net', 'sas3-1526.search.yandex.net', 'sas1-9957.search.yandex.net', 'sas3-0288.search.yandex.net', 'sas3-0124.search.yandex.net', 'sas5-2002.search.yandex.net', 'sas0-5247.search.yandex.net', 'sas3-2138.search.yandex.net', 'sas0-5258.search.yandex.net', 'sas3-1553.search.yandex.net', 'sas3-0274.search.yandex.net', 'sas3-0161.search.yandex.net', 'sas3-0162.search.yandex.net', 'sas5-5677.search.yandex.net', 'sas3-1523.search.yandex.net', 'sas1-9949.search.yandex.net', 'sas2-8459.search.yandex.net', 'sas3-1507.search.yandex.net', 'sas3-1512.search.yandex.net', 'sas3-1546.search.yandex.net', 'sas3-0165.search.yandex.net', 'sas2-8464.search.yandex.net', 'sas4-3436.search.yandex.net', 'sas4-3439.search.yandex.net', 'sas2-8460.search.yandex.net', 'sas3-8529.search.yandex.net', 'sas3-1541.search.yandex.net', 'sas3-0118.search.yandex.net', 'sas1-9796.search.yandex.net', 'sas0-5257.search.yandex.net', 'sas3-1131.search.yandex.net', 'sas3-0157.search.yandex.net', 'sas5-7487.search.yandex.net', 'sas1-9776.search.yandex.net', 'sas1-9770.search.yandex.net', 'sas1-9956.search.yandex.net', 'sas0-5242.search.yandex.net', 'sas3-1525.search.yandex.net', 'sas3-1509.search.yandex.net', 'sas3-0276.search.yandex.net', 'sas3-8528.search.yandex.net', 'sas3-2700.search.yandex.net', 'sas0-6377.search.yandex.net', 'sas0-6375.search.yandex.net', 'sas3-1529.search.yandex.net', 'sas1-9922.search.yandex.net', 'sas3-1504.search.yandex.net', 'sas1-9857.search.yandex.net', 'sas3-0119.search.yandex.net', 'sas0-6381.search.yandex.net', 'sas3-0122.search.yandex.net', 'sas3-0282.search.yandex.net', 'sas3-1522.search.yandex.net', 'sas2-9409.search.yandex.net', 'sas1-9805.search.yandex.net', 'sas0-5256.search.yandex.net', 'sas3-1551.search.yandex.net', 'sas3-0289.search.yandex.net', 'sas3-0270.search.yandex.net', 'sas0-5246.search.yandex.net', 'sas1-9950.search.yandex.net', 'sas0-6382.search.yandex.net', 'sas1-9862.search.yandex.net', 'sas1-9960.search.yandex.net', 'sas0-6385.search.yandex.net', 'sas1-9997.search.yandex.net', 'sas3-1506.search.yandex.net', 'sas1-9958.search.yandex.net', 'sas0-6569.search.yandex.net', 'sas3-2699.search.yandex.net', 'sas0-6383.search.yandex.net', 'sas0-5245.search.yandex.net', 'sas5-7490.search.yandex.net', 'sas3-1534.search.yandex.net', 'sas3-1538.search.yandex.net', 'sas3-8527.search.yandex.net', 'sas4-8705.search.yandex.net', 'sas3-1511.search.yandex.net', 'sas3-0163.search.yandex.net', 'sas1-9858.search.yandex.net', 'sas1-9951.search.yandex.net', 'sas1-9863.search.yandex.net', 'sas1-9902.search.yandex.net', 'sas3-2701.search.yandex.net', 'sas4-3437.search.yandex.net', 'sas3-0158.search.yandex.net', 'sas0-5237.search.yandex.net', 'sas4-3440.search.yandex.net', 'sas1-9790.search.yandex.net', 'sas3-0164.search.yandex.net', 'sas3-0283.search.yandex.net', 'sas0-6135.search.yandex.net', 'sas1-9798.search.yandex.net', 'sas1-0414.search.yandex.net', 'sas3-3495.search.yandex.net', 'sas3-2166.search.yandex.net', 'sas3-2168.search.yandex.net', 'sas1-9860.search.yandex.net', 'sas3-1552.search.yandex.net', 'sas3-1545.search.yandex.net', 'sas3-2147.search.yandex.net', 'sas3-1132.search.yandex.net', 'sas2-8191.search.yandex.net', 'sas3-0279.search.yandex.net', 'sas3-0281.search.yandex.net', 'sas2-7754.search.yandex.net', 'sas1-9773.search.yandex.net', 'sas0-6133.search.yandex.net', 'sas2-1336.search.yandex.net', 'sas3-2151.search.yandex.net', 'sas3-1530.search.yandex.net', 'sas1-9793.search.yandex.net', 'vla2-9081.search.yandex.net', 'vla2-8619.search.yandex.net', 'vla2-8618.search.yandex.net', 'vla2-8240.search.yandex.net', 'vla2-8255.search.yandex.net', 'vla2-9075.search.yandex.net', 'vla2-5912.search.yandex.net', 'vla2-5604.search.yandex.net', 'vla2-8625.search.yandex.net', 'vla3-2274.search.yandex.net', 'vla0-5391.search.yandex.net', 'vla2-8634.search.yandex.net', 'vla3-4477.search.yandex.net', 'vla2-8643.search.yandex.net', 'vla2-8239.search.yandex.net', 'vla2-8227.search.yandex.net', 'vla0-5424.search.yandex.net', 'vla2-5916.search.yandex.net', 'vla2-9073.search.yandex.net', 'vla1-0908.search.yandex.net', 'vla2-8254.search.yandex.net', 'vla2-8621.search.yandex.net', 'vla2-8753.search.yandex.net', 'vla0-5403.search.yandex.net', 'vla2-8627.search.yandex.net', 'vla2-5917.search.yandex.net', 'vla3-2267.search.yandex.net', 'vla2-8159.search.yandex.net', 'vla3-4447.search.yandex.net', 'vla2-8237.search.yandex.net', 'vla2-8637.search.yandex.net', 'vla2-9071.search.yandex.net', 'vla2-9087.search.yandex.net', 'vla0-5405.search.yandex.net', 'vla2-8714.search.yandex.net', 'vla2-8171.search.yandex.net', 'vla2-8232.search.yandex.net', 'vla0-5414.search.yandex.net', 'vla2-5621.search.yandex.net', 'vla0-5408.search.yandex.net', 'vla2-8638.search.yandex.net', 'vla3-2268.search.yandex.net', 'vla3-4448.search.yandex.net', 'vla2-8628.search.yandex.net', 'vla2-9074.search.yandex.net', 'vla2-8754.search.yandex.net', 'vla2-8172.search.yandex.net', 'vla3-2253.search.yandex.net', 'vla2-8233.search.yandex.net', 'vla2-8223.search.yandex.net', 'vla0-5370.search.yandex.net', 'vla0-6101.search.yandex.net', 'vla2-8242.search.yandex.net', 'vla0-5373.search.yandex.net', 'vla2-8752.search.yandex.net', 'vla1-3331.search.yandex.net', 'vla2-8626.search.yandex.net', 'vla3-2252.search.yandex.net', 'vla0-5406.search.yandex.net', 'vla0-4560.search.yandex.net', 'vla3-4452.search.yandex.net', 'vla2-8636.search.yandex.net', 'vla2-9084.search.yandex.net', 'vla2-8250.search.yandex.net', 'vla2-8249.search.yandex.net', 'vla3-2258.search.yandex.net', 'vla0-5404.search.yandex.net', 'vla0-5374.search.yandex.net', 'vla3-2250.search.yandex.net', 'vla2-8167.search.yandex.net', 'vla0-5390.search.yandex.net', 'vla2-5619.search.yandex.net', 'vla2-8644.search.yandex.net', 'vla2-8165.search.yandex.net', 'vla2-8236.search.yandex.net', 'vla3-4467.search.yandex.net', 'vla0-5371.search.yandex.net', 'vla2-8612.search.yandex.net', 'vla2-5622.search.yandex.net', 'vla3-2247.search.yandex.net', 'vla3-2246.search.yandex.net', 'vla2-8610.search.yandex.net', 'vla2-8755.search.yandex.net', 'vla2-8170.search.yandex.net', 'vla2-8228.search.yandex.net', 'vla2-8234.search.yandex.net', 'vla2-8257.search.yandex.net', 'vla2-8607.search.yandex.net', 'vla2-8639.search.yandex.net', 'vla2-8750.search.yandex.net', 'vla3-4469.search.yandex.net', 'vla2-8609.search.yandex.net', 'vla2-8617.search.yandex.net', 'vla2-8642.search.yandex.net', 'vla3-2276.search.yandex.net', 'vla2-8230.search.yandex.net', 'vla0-5396.search.yandex.net', 'vla3-4449.search.yandex.net', 'vla0-5401.search.yandex.net', 'vla3-4476.search.yandex.net', 'vla3-2249.search.yandex.net', 'vla2-8243.search.yandex.net', 'vla0-7311.search.yandex.net', 'vla2-8161.search.yandex.net', 'vla2-8605.search.yandex.net', 'vla3-2261.search.yandex.net', 'vla2-8252.search.yandex.net', 'vla3-2275.search.yandex.net', 'vla2-8226.search.yandex.net', 'vla0-5395.search.yandex.net', 'vla0-5411.search.yandex.net', 'vla0-5400.search.yandex.net', 'vla3-4468.search.yandex.net', 'vla2-8631.search.yandex.net', 'vla0-5413.search.yandex.net', 'vla3-4446.search.yandex.net', 'vla3-2245.search.yandex.net', 'vla2-9083.search.yandex.net', 'vla3-2273.search.yandex.net', 'vla2-8164.search.yandex.net', 'vla2-8222.search.yandex.net', 'vla2-8160.search.yandex.net', 'vla3-2263.search.yandex.net', 'vla0-5412.search.yandex.net', 'vla3-2270.search.yandex.net', 'vla3-2259.search.yandex.net', 'vla3-4453.search.yandex.net', 'vla0-5399.search.yandex.net', 'vla2-5918.search.yandex.net', 'vla2-8622.search.yandex.net', 'vla2-8229.search.yandex.net', 'vla2-8632.search.yandex.net', 'vla2-8246.search.yandex.net', 'vla3-4474.search.yandex.net', 'vla3-4450.search.yandex.net', 'vla2-8606.search.yandex.net', 'vla2-5906.search.yandex.net', 'vla2-9077.search.yandex.net', 'vla2-8624.search.yandex.net', 'vla3-2254.search.yandex.net', 'vla2-1468.search.yandex.net', 'vla2-8169.search.yandex.net', 'vla2-8231.search.yandex.net', 'vla2-8225.search.yandex.net', 'vla3-4454.search.yandex.net', 'vla0-5418.search.yandex.net', 'vla0-4564.search.yandex.net', 'vla2-9078.search.yandex.net', 'vla3-2251.search.yandex.net', 'vla2-8645.search.yandex.net', 'vla2-8221.search.yandex.net', 'vla3-4445.search.yandex.net', 'vla2-5612.search.yandex.net', 'vla2-8168.search.yandex.net', 'vla0-5393.search.yandex.net', 'vla2-8620.search.yandex.net', 'vla2-8173.search.yandex.net', 'vla2-8646.search.yandex.net', 'vla0-5394.search.yandex.net', 'vla2-8235.search.yandex.net', 'vla0-6103.search.yandex.net', 'vla3-2264.search.yandex.net', 'vla0-5422.search.yandex.net', 'vla3-2257.search.yandex.net', 'vla1-6290.search.yandex.net', 'vla0-4563.search.yandex.net', 'vla2-8245.search.yandex.net', 'vla0-5419.search.yandex.net', 'vla2-8615.search.yandex.net', 'vla2-8256.search.yandex.net', 'vla2-8224.search.yandex.net', 'vla0-5402.search.yandex.net', 'vla2-8629.search.yandex.net', 'vla1-6278.search.yandex.net', 'vla3-2260.search.yandex.net', 'vla2-8251.search.yandex.net', 'vla2-8611.search.yandex.net', 'vla2-8640.search.yandex.net', 'vla3-2262.search.yandex.net', 'vla2-8158.search.yandex.net', 'vla3-4451.search.yandex.net', 'vla2-8630.search.yandex.net', 'vla0-5423.search.yandex.net', 'vla2-8713.search.yandex.net', 'vla2-8715.search.yandex.net', 'vla0-5417.search.yandex.net', 'vla2-9088.search.yandex.net', 'vla0-4561.search.yandex.net', 'vla2-8613.search.yandex.net', 'vla2-9082.search.yandex.net', 'vla3-4478.search.yandex.net', 'vla2-8241.search.yandex.net', 'vla2-5614.search.yandex.net', 'vla2-8238.search.yandex.net', 'vla2-1453.search.yandex.net', 'vla2-8248.search.yandex.net', 'vla0-5392.search.yandex.net', 'vla0-5398.search.yandex.net', 'vla3-4475.search.yandex.net', 'vla2-8244.search.yandex.net', 'vla2-8623.search.yandex.net', 'vla2-5907.search.yandex.net', 'vla1-3330.search.yandex.net', 'vla2-8614.search.yandex.net', 'vla0-5397.search.yandex.net', 'vla2-8716.search.yandex.net', 'vla0-4562.search.yandex.net', 'vla2-8162.search.yandex.net', 'vla0-5410.search.yandex.net', 'vla2-9070.search.yandex.net', 'vla0-5407.search.yandex.net', 'vla2-5919.search.yandex.net', 'vla2-8608.search.yandex.net', 'vla0-4559.search.yandex.net', 'vla0-5409.search.yandex.net'])"
        val: HOSTMAN-975-exp
      - exp: "h(['sas0-5235.search.yandex.net'])"
        val: HOSTMAN-975-test
      - exp: "h(['sas1-0245.search.yandex.net', 'sas1-1812.search.yandex.net', 'sas5-9350.search.yandex.net', 'sas3-2271.search.yandex.net', 'sas5-9529.search.yandex.net', 'sas1-2231.search.yandex.net', 'sas2-1515.search.yandex.net', 'sas2-1461.search.yandex.net', 'sas2-1454.search.yandex.net', 'sas2-1539.search.yandex.net', 'sas2-1462.search.yandex.net', 'sas2-1517.search.yandex.net', 'sas4-3304.search.yandex.net', 'sas4-3290.search.yandex.net', 'sas5-8840.search.yandex.net', 'sas1-1849.search.yandex.net', 'sas2-2965.search.yandex.net', 'sas2-2639.search.yandex.net', 'sas2-1516.search.yandex.net', 'sas2-1459.search.yandex.net', 'sas2-1467.search.yandex.net', 'sas2-1450.search.yandex.net', 'sas2-1543.search.yandex.net', 'sas2-1469.search.yandex.net', 'sas2-1457.search.yandex.net', 'sas2-1472.search.yandex.net', 'sas2-1538.search.yandex.net', 'sas2-1519.search.yandex.net', 'sas2-1463.search.yandex.net', 'sas0-8289.search.yandex.net', 'sas2-1514.search.yandex.net', 'sas2-1458.search.yandex.net', 'sas2-1455.search.yandex.net', 'sas2-1449.search.yandex.net', 'sas2-1470.search.yandex.net', 'sas2-1544.search.yandex.net', 'sas2-1518.search.yandex.net', 'sas2-1460.search.yandex.net', 'sas0-9999.search.yandex.net', 'sas2-1464.search.yandex.net', 'sas2-1448.search.yandex.net', 'sas2-1542.search.yandex.net', 'sas2-1541.search.yandex.net', 'sas2-1466.search.yandex.net', 'sas2-1452.search.yandex.net', 'sas2-1468.search.yandex.net', 'sas2-1894.search.yandex.net', 'sas3-8746.search.yandex.net', 'sas2-1456.search.yandex.net', 'sas0-6473.search.yandex.net', 'sas2-1545.search.yandex.net', 'sas2-1451.search.yandex.net', 'sas2-2644.search.yandex.net', 'sas2-1471.search.yandex.net', 'sas2-1465.search.yandex.net', 'sas5-7825.search.yandex.net', 'sas2-2973.search.yandex.net', 'sas5-5445.search.yandex.net', 'sas1-2065.search.yandex.net', 'sas5-7815.search.yandex.net', 'sas5-8827.search.yandex.net', 'sas5-8842.search.yandex.net', 'sas4-7286.search.yandex.net', 'sas5-8848.search.yandex.net', 'sas5-8847.search.yandex.net', 'sas5-8852.search.yandex.net', 'sas5-8830.search.yandex.net', 'sas4-3243.search.yandex.net', 'sas4-3236.search.yandex.net', 'sas5-5815.search.yandex.net', 'sas3-0614.search.yandex.net', 'sas5-5814.search.yandex.net', 'sas3-0976.search.yandex.net', 'sas5-5816.search.yandex.net', 'sas5-3977.search.yandex.net', 'sas3-7666.search.yandex.net', 'sas5-9531.search.yandex.net', 'sas3-8735.search.yandex.net', 'sas3-8750.search.yandex.net', 'sas3-8736.search.yandex.net', 'sas3-8688.search.yandex.net', 'sas3-8683.search.yandex.net', 'sas1-1885.search.yandex.net', 'sas4-3235.search.yandex.net', 'sas5-3971.search.yandex.net', 'sas0-6514.search.yandex.net', 'sas3-8677.search.yandex.net', 'sas2-1540.search.yandex.net', 'sas4-4950.search.yandex.net', 'sas5-9522.search.yandex.net', 'sas2-1189.search.yandex.net', 'sas4-3250.search.yandex.net', 'sas3-1115.search.yandex.net', 'sas2-0824.search.yandex.net', 'sas1-2424.search.yandex.net', 'sas4-7287.search.yandex.net', 'sas5-8841.search.yandex.net', 'sas2-2095.search.yandex.net', 'sas5-8838.search.yandex.net', 'sas2-2402.search.yandex.net', 'sas5-8831.search.yandex.net', 'sas5-8843.search.yandex.net', 'sas5-1169.search.yandex.net', 'sas2-2994.search.yandex.net', 'sas4-7289.search.yandex.net', 'sas5-8832.search.yandex.net', 'sas5-8837.search.yandex.net', 'sas5-8833.search.yandex.net', 'sas5-8839.search.yandex.net', 'sas2-2388.search.yandex.net', 'sas2-2431.search.yandex.net', 'sas4-7290.search.yandex.net', 'sas5-8845.search.yandex.net', 'sas2-5341.search.yandex.net', 'sas3-7625.search.yandex.net', 'sas2-5345.search.yandex.net', 'sas3-7651.search.yandex.net', 'sas2-5338.search.yandex.net', 'sas2-5353.search.yandex.net', 'sas2-6746.search.yandex.net', 'sas2-5426.search.yandex.net', 'sas3-7668.search.yandex.net', 'sas3-7643.search.yandex.net', 'sas5-9519.search.yandex.net', 'sas2-5846.search.yandex.net', 'sas2-5430.search.yandex.net', 'sas3-7670.search.yandex.net', 'sas3-7638.search.yandex.net', 'sas2-3042.search.yandex.net', 'sas2-5350.search.yandex.net', 'sas3-7632.search.yandex.net', 'sas3-8685.search.yandex.net', 'sas3-8758.search.yandex.net', 'sas3-8733.search.yandex.net', 'sas3-8681.search.yandex.net', 'sas5-1168.search.yandex.net', 'sas4-6703.search.yandex.net', 'sas5-1180.search.yandex.net', 'sas5-2469.search.yandex.net', 'sas4-5606.search.yandex.net', 'sas3-8689.search.yandex.net', 'sas1-1957.search.yandex.net', 'sas4-3239.search.yandex.net', 'sas3-8693.search.yandex.net', 'sas3-8701.search.yandex.net', 'sas2-1798.search.yandex.net', 'sas5-1190.search.yandex.net', 'sas3-8734.search.yandex.net', 'sas3-8679.search.yandex.net', 'sas3-8684.search.yandex.net', 'sas1-0245.search.yandex.net', 'sas1-1812.search.yandex.net', 'sas3-2271.search.yandex.net', 'sas5-9529.search.yandex.net', 'sas1-2231.search.yandex.net', 'sas2-1515.search.yandex.net', 'sas2-1461.search.yandex.net', 'sas2-1454.search.yandex.net', 'sas2-1539.search.yandex.net', 'sas2-1462.search.yandex.net', 'sas0-4264.search.yandex.net', 'sas2-1517.search.yandex.net', 'sas4-3304.search.yandex.net', 'sas4-3290.search.yandex.net', 'sas1-1291.search.yandex.net', 'sas0-4277.search.yandex.net', 'sas1-1294.search.yandex.net', 'sas1-1307.search.yandex.net', 'sas4-5889.search.yandex.net', 'sas5-8840.search.yandex.net', 'sas0-4268.search.yandex.net', 'sas1-1849.search.yandex.net', 'sas2-2965.search.yandex.net', 'sas2-2639.search.yandex.net', 'sas1-9917.search.yandex.net', 'sas2-1516.search.yandex.net', 'sas2-1459.search.yandex.net', 'sas2-1467.search.yandex.net', 'sas2-1450.search.yandex.net', 'sas2-1543.search.yandex.net', 'sas2-1469.search.yandex.net', 'sas2-1457.search.yandex.net', 'sas2-1472.search.yandex.net', 'sas2-1538.search.yandex.net', 'sas2-1519.search.yandex.net', 'sas2-1463.search.yandex.net', 'sas0-8289.search.yandex.net', 'sas4-6163.search.yandex.net', 'sas2-1514.search.yandex.net', 'sas2-1458.search.yandex.net', 'sas2-1455.search.yandex.net', 'sas2-1449.search.yandex.net', 'sas2-1470.search.yandex.net', 'sas2-1544.search.yandex.net', 'sas2-1518.search.yandex.net', 'sas2-1460.search.yandex.net', 'sas0-9999.search.yandex.net', 'sas2-1464.search.yandex.net', 'sas3-1383.search.yandex.net', 'sas2-1448.search.yandex.net', 'sas2-1542.search.yandex.net', 'sas2-1541.search.yandex.net', 'sas2-1466.search.yandex.net', 'sas2-1452.search.yandex.net', 'sas2-1468.search.yandex.net', 'sas2-1894.search.yandex.net', 'sas2-1456.search.yandex.net', 'sas0-6473.search.yandex.net', 'sas2-9348.search.yandex.net', 'sas2-1545.search.yandex.net', 'sas2-1451.search.yandex.net', 'sas2-2644.search.yandex.net', 'sas2-1471.search.yandex.net', 'sas2-1465.search.yandex.net', 'sas5-7825.search.yandex.net', 'sas2-2973.search.yandex.net', 'sas5-5445.search.yandex.net', 'sas1-2065.search.yandex.net', 'sas5-7815.search.yandex.net', 'sas5-8827.search.yandex.net', 'sas5-8842.search.yandex.net', 'sas1-1341.search.yandex.net', 'sas1-1276.search.yandex.net', 'sas1-1309.search.yandex.net', 'sas4-7286.search.yandex.net', 'sas4-6027.search.yandex.net', 'sas5-8848.search.yandex.net', 'sas5-8847.search.yandex.net', 'sas5-8852.search.yandex.net', 'sas4-6619.search.yandex.net', 'sas5-8830.search.yandex.net', 'sas4-3243.search.yandex.net', 'sas4-3236.search.yandex.net', 'sas5-5815.search.yandex.net', 'sas3-0614.search.yandex.net', 'sas5-5814.search.yandex.net', 'sas3-0976.search.yandex.net', 'sas5-5816.search.yandex.net', 'sas5-3977.search.yandex.net', 'sas4-6003.search.yandex.net', 'sas3-7666.search.yandex.net', 'sas2-9352.search.yandex.net', 'sas5-9531.search.yandex.net', 'sas3-8735.search.yandex.net', 'sas3-8750.search.yandex.net', 'sas3-8736.search.yandex.net', 'sas3-8688.search.yandex.net', 'sas3-8683.search.yandex.net', 'sas1-1885.search.yandex.net', 'sas4-3235.search.yandex.net', 'sas5-3971.search.yandex.net', 'sas0-6514.search.yandex.net', 'sas3-8677.search.yandex.net', 'sas4-6382.search.yandex.net', 'sas2-1540.search.yandex.net', 'sas4-4950.search.yandex.net', 'sas5-9522.search.yandex.net', 'sas2-1189.search.yandex.net', 'sas4-3250.search.yandex.net', 'sas3-1115.search.yandex.net', 'sas2-0824.search.yandex.net', 'sas1-2424.search.yandex.net', 'sas4-7287.search.yandex.net', 'sas5-8841.search.yandex.net', 'sas2-2095.search.yandex.net', 'sas5-8838.search.yandex.net', 'sas2-2402.search.yandex.net', 'sas5-8831.search.yandex.net', 'sas4-5661.search.yandex.net', 'sas5-8843.search.yandex.net', 'sas5-1169.search.yandex.net', 'sas4-6181.search.yandex.net', 'sas2-2994.search.yandex.net', 'sas4-5614.search.yandex.net', 'sas4-7289.search.yandex.net', 'sas5-8832.search.yandex.net', 'sas5-8837.search.yandex.net', 'sas5-8833.search.yandex.net', 'sas5-8839.search.yandex.net', 'sas2-2388.search.yandex.net', 'sas2-2431.search.yandex.net', 'sas4-7290.search.yandex.net', 'sas4-5949.search.yandex.net', 'sas5-8845.search.yandex.net', 'sas2-5341.search.yandex.net', 'sas3-7625.search.yandex.net', 'sas2-5345.search.yandex.net', 'sas3-7651.search.yandex.net', 'sas2-5338.search.yandex.net', 'sas2-5353.search.yandex.net', 'sas2-6746.search.yandex.net', 'sas2-5426.search.yandex.net', 'sas3-7668.search.yandex.net', 'sas3-7643.search.yandex.net', 'sas5-9519.search.yandex.net', 'sas2-5846.search.yandex.net', 'sas2-5430.search.yandex.net', 'sas3-7670.search.yandex.net', 'sas3-7638.search.yandex.net', 'sas2-3042.search.yandex.net', 'sas2-5350.search.yandex.net', 'sas3-7632.search.yandex.net', 'sas3-8685.search.yandex.net', 'sas3-8758.search.yandex.net', 'sas3-8733.search.yandex.net', 'sas3-8681.search.yandex.net', 'sas5-1168.search.yandex.net', 'sas2-4234.search.yandex.net', 'sas4-6703.search.yandex.net', 'sas5-1180.search.yandex.net', 'sas4-6012.search.yandex.net', 'sas4-5711.search.yandex.net', 'sas5-2469.search.yandex.net', 'sas4-5606.search.yandex.net', 'sas3-8689.search.yandex.net', 'sas1-1957.search.yandex.net', 'sas3-8737.search.yandex.net', 'sas4-3239.search.yandex.net', 'sas3-8693.search.yandex.net', 'sas3-8701.search.yandex.net', 'sas2-1798.search.yandex.net', 'sas5-1190.search.yandex.net', 'sas3-8734.search.yandex.net', 'sas3-8679.search.yandex.net', 'sas3-8684.search.yandex.net', 'sas3-8746.search.yandex.net', 'sas3-8732.search.yandex.net', 'sas3-8680.search.yandex.net', 'sas3-8691.search.yandex.net', 'sas3-8702.search.yandex.net', 'sas2-5456.search.yandex.net', 'sas2-0945.search.yandex.net', 'sas4-6750.search.yandex.net', 'sas2-5437.search.yandex.net', 'sas3-4305.search.yandex.net', 'sas3-8678.search.yandex.net', 'sas3-9160.search.yandex.net', 'sas4-3217.search.yandex.net', 'sas3-9157.search.yandex.net', 'sas5-7817.search.yandex.net', 'sas4-6367.search.yandex.net', 'sas4-5702.search.yandex.net', 'sas5-9771.search.yandex.net', 'sas3-9162.search.yandex.net', 'sas3-9159.search.yandex.net', 'sas3-9165.search.yandex.net', 'sas0-8381.search.yandex.net', 'sas4-3520.search.yandex.net', 'sas2-1475.search.yandex.net', 'sas3-9158.search.yandex.net', 'sas3-3025.search.yandex.net', 'sas2-0908.search.yandex.net', 'sas3-8749.search.yandex.net', 'sas4-6722.search.yandex.net', 'sas4-6723.search.yandex.net', 'sas3-8682.search.yandex.net', 'sas3-8694.search.yandex.net', 'sas5-5363.search.yandex.net', 'sas2-2061.search.yandex.net', 'sas3-8686.search.yandex.net', 'sas3-8692.search.yandex.net', 'sas3-8703.search.yandex.net', 'sas2-1473.search.yandex.net', 'sas4-3271.search.yandex.net', 'sas5-1182.search.yandex.net', 'sas3-8690.search.yandex.net', 'sas4-3245.search.yandex.net', 'sas5-5364.search.yandex.net', 'sas3-8753.search.yandex.net', 'sas2-1529.search.yandex.net', 'sas3-8687.search.yandex.net', 'sas3-8752.search.yandex.net', 'sas4-3303.search.yandex.net', 'sas3-1001.search.yandex.net', 'sas1-1954.search.yandex.net', 'sas1-1804.search.yandex.net', 'sas5-2470.search.yandex.net', 'sas5-3946.search.yandex.net', 'sas2-2983.search.yandex.net', 'sas5-3953.search.yandex.net', 'sas5-3952.search.yandex.net', 'sas1-2342.search.yandex.net', 'sas5-8250.search.yandex.net', 'sas5-5456.search.yandex.net', 'sas3-3026.search.yandex.net', 'sas1-2252.search.yandex.net', 'sas4-5965.search.yandex.net', 'sas1-2411.search.yandex.net', 'sas4-6352.search.yandex.net', 'sas2-1187.search.yandex.net', 'sas2-2594.search.yandex.net', 'sas4-6377.search.yandex.net', 'sas2-2214.search.yandex.net', 'sas2-3003.search.yandex.net', 'sas2-1533.search.yandex.net', 'sas3-8704.search.yandex.net', 'sas2-1474.search.yandex.net', 'sas3-8755.search.yandex.net', 'sas2-1521.search.yandex.net', 'sas3-8705.search.yandex.net', 'sas2-1551.search.yandex.net', 'sas5-1224.search.yandex.net', 'sas0-6523.search.yandex.net', 'sas2-1548.search.yandex.net', 'sas5-8741.search.yandex.net', 'sas2-2908.search.yandex.net', 'sas5-7903.search.yandex.net', 'sas5-3978.search.yandex.net', 'sas2-6747.search.yandex.net', 'sas5-7925.search.yandex.net', 'sas3-7639.search.yandex.net', 'sas5-3976.search.yandex.net', 'sas3-1009.search.yandex.net', 'sas5-7905.search.yandex.net', 'sas5-1189.search.yandex.net', 'sas3-2273.search.yandex.net', 'sas5-3975.search.yandex.net', 'sas5-9539.search.yandex.net', 'sas2-1532.search.yandex.net', 'sas1-6589.search.yandex.net', 'sas3-1709.search.yandex.net', 'sas1-2077.search.yandex.net', 'sas1-1760.search.yandex.net', 'sas5-9868.search.yandex.net', 'sas2-1522.search.yandex.net', 'sas5-9499.search.yandex.net', 'sas4-3238.search.yandex.net', 'sas3-8877.search.yandex.net', 'sas3-7653.search.yandex.net', 'sas3-7642.search.yandex.net', 'sas2-1525.search.yandex.net', 'sas2-5343.search.yandex.net', 'sas4-3237.search.yandex.net', 'sas2-5356.search.yandex.net', 'sas1-0423.search.yandex.net', 'sas3-7648.search.yandex.net', 'sas5-1181.search.yandex.net', 'sas5-7880.search.yandex.net', 'sas3-7663.search.yandex.net', 'sas3-7641.search.yandex.net', 'sas5-7875.search.yandex.net', 'sas1-1972.search.yandex.net', 'sas3-7665.search.yandex.net', 'sas1-2416.search.yandex.net', 'sas2-5372.search.yandex.net', 'sas2-5428.search.yandex.net', 'sas5-7906.search.yandex.net', 'sas3-5527.search.yandex.net', 'sas5-9869.search.yandex.net', 'sas5-7926.search.yandex.net', 'sas5-8960.search.yandex.net', 'sas0-4272.search.yandex.net', 'sas2-1550.search.yandex.net', 'sas2-1520.search.yandex.net', 'sas1-2223.search.yandex.net', 'sas5-7883.search.yandex.net', 'sas4-5890.search.yandex.net', 'sas5-7915.search.yandex.net', 'sas5-7866.search.yandex.net', 'sas5-7927.search.yandex.net', 'sas5-3968.search.yandex.net', 'sas5-7924.search.yandex.net', 'sas5-7921.search.yandex.net', 'sas5-7870.search.yandex.net', 'sas5-7882.search.yandex.net', 'sas5-7900.search.yandex.net', 'sas3-7664.search.yandex.net', 'sas5-8738.search.yandex.net', 'sas1-0407.search.yandex.net', 'sas3-3463.search.yandex.net', 'sas3-7645.search.yandex.net', 'sas2-1527.search.yandex.net', 'sas3-3465.search.yandex.net', 'sas2-1549.search.yandex.net', 'sas2-1547.search.yandex.net', 'sas2-1512.search.yandex.net', 'sas5-1194.search.yandex.net', 'sas5-1167.search.yandex.net', 'sas2-1526.search.yandex.net', 'sas4-5848.search.yandex.net', 'sas2-1534.search.yandex.net', 'sas3-0604.search.yandex.net', 'sas2-1513.search.yandex.net', 'sas3-8785.search.yandex.net', 'sas2-2816.search.yandex.net', 'sas2-1878.search.yandex.net', 'sas2-3005.search.yandex.net', 'sas3-5457.search.yandex.net', 'sas2-1908.search.yandex.net', 'sas5-9750.search.yandex.net', 'sas5-9738.search.yandex.net', 'sas5-9753.search.yandex.net', 'sas0-9957.search.yandex.net', 'sas5-9736.search.yandex.net', 'sas5-9735.search.yandex.net', 'sas5-9752.search.yandex.net', 'sas5-9739.search.yandex.net', 'sas5-9761.search.yandex.net', 'sas5-9748.search.yandex.net', 'sas5-9741.search.yandex.net', 'sas5-9737.search.yandex.net', 'sas5-9749.search.yandex.net', 'sas2-3735.search.yandex.net', 'sas0-9956.search.yandex.net', 'sas1-0033.search.yandex.net', 'sas0-9959.search.yandex.net', 'sas1-0176.search.yandex.net', 'sas1-0274.search.yandex.net', 'sas1-0214.search.yandex.net', 'sas1-0271.search.yandex.net', 'sas1-0044.search.yandex.net', 'sas0-9946.search.yandex.net', 'sas1-0307.search.yandex.net', 'sas0-9954.search.yandex.net', 'sas0-9944.search.yandex.net', 'sas0-9945.search.yandex.net', 'sas0-9951.search.yandex.net', 'sas3-2266.search.yandex.net', 'sas1-0298.search.yandex.net', 'sas0-9955.search.yandex.net', 'sas1-0031.search.yandex.net', 'sas1-0304.search.yandex.net', 'sas0-9960.search.yandex.net', 'sas1-0150.search.yandex.net', 'sas0-9949.search.yandex.net', 'sas1-0283.search.yandex.net', 'sas0-9952.search.yandex.net', 'sas0-9942.search.yandex.net', 'sas0-9953.search.yandex.net', 'sas0-9950.search.yandex.net', 'sas1-0013.search.yandex.net', 'sas0-9948.search.yandex.net', 'sas0-9947.search.yandex.net', 'sas0-9943.search.yandex.net', 'sas1-0209.search.yandex.net', 'sas1-0282.search.yandex.net', 'sas2-1904.search.yandex.net', 'sas0-6626.search.yandex.net', 'sas3-8795.search.yandex.net', 'sas3-2324.search.yandex.net', 'sas3-2269.search.yandex.net', 'sas3-2303.search.yandex.net', 'sas5-6145.search.yandex.net', 'sas3-2274.search.yandex.net', 'sas5-6146.search.yandex.net', 'sas5-6230.search.yandex.net', 'sas3-2457.search.yandex.net', 'sas5-6160.search.yandex.net', 'sas1-9227.search.yandex.net', 'sas5-6163.search.yandex.net', 'sas3-2458.search.yandex.net', 'sas2-2206.search.yandex.net', 'sas3-8967.search.yandex.net', 'sas3-2279.search.yandex.net', 'sas3-9474.search.yandex.net', 'sas3-2782.search.yandex.net', 'sas2-2882.search.yandex.net', 'sas1-0398.search.yandex.net', 'sas0-4269.search.yandex.net', 'sas0-4270.search.yandex.net', 'sas0-4273.search.yandex.net', 'sas5-8851.search.yandex.net', 'sas3-3411.search.yandex.net', 'sas4-6175.search.yandex.net', 'sas3-3165.search.yandex.net', 'sas1-2434.search.yandex.net', 'sas2-2503.search.yandex.net', 'sas5-0907.search.yandex.net', 'sas3-2929.search.yandex.net', 'sas3-2973.search.yandex.net', 'sas3-2859.search.yandex.net', 'sas3-2861.search.yandex.net', 'sas4-5742.search.yandex.net', 'sas3-2919.search.yandex.net', 'sas3-2928.search.yandex.net', 'sas5-8663.search.yandex.net', 'sas3-2883.search.yandex.net', 'sas3-2905.search.yandex.net', 'sas3-2918.search.yandex.net', 'sas3-2933.search.yandex.net', 'sas3-2965.search.yandex.net', 'sas3-2876.search.yandex.net', 'sas3-2881.search.yandex.net', 'sas3-2904.search.yandex.net', 'sas3-2923.search.yandex.net', 'sas3-2927.search.yandex.net', 'sas3-2977.search.yandex.net', 'sas3-2872.search.yandex.net', 'sas3-2880.search.yandex.net', 'sas3-2917.search.yandex.net', 'sas3-2930.search.yandex.net', 'sas3-2972.search.yandex.net', 'sas3-2860.search.yandex.net', 'sas3-2866.search.yandex.net', 'sas3-2894.search.yandex.net', 'sas3-2916.search.yandex.net', 'sas3-2938.search.yandex.net', 'sas3-2967.search.yandex.net', 'sas3-2854.search.yandex.net', 'sas3-2870.search.yandex.net', 'sas3-2902.search.yandex.net', 'sas3-2934.search.yandex.net', 'sas3-2957.search.yandex.net', 'sas3-2852.search.yandex.net', 'sas3-2864.search.yandex.net', 'sas3-2901.search.yandex.net', 'sas3-2915.search.yandex.net', 'sas3-2948.search.yandex.net', 'sas3-2970.search.yandex.net', 'sas3-2853.search.yandex.net', 'sas3-2862.search.yandex.net', 'sas3-2867.search.yandex.net', 'sas3-2903.search.yandex.net', 'sas3-2909.search.yandex.net', 'sas3-2946.search.yandex.net', 'sas3-2956.search.yandex.net', 'sas3-2886.search.yandex.net', 'sas3-2924.search.yandex.net', 'sas3-2944.search.yandex.net', 'sas3-2963.search.yandex.net', 'sas3-2877.search.yandex.net', 'sas3-2921.search.yandex.net', 'sas3-2939.search.yandex.net', 'sas3-2960.search.yandex.net', 'sas3-2878.search.yandex.net', 'sas3-2898.search.yandex.net', 'sas3-2907.search.yandex.net', 'sas1-7629.search.yandex.net', 'sas3-3124.search.yandex.net', 'sas1-1991.search.yandex.net', 'sas1-2062.search.yandex.net', 'sas2-1194.search.yandex.net', 'sas0-8368.search.yandex.net', 'sas4-9170.search.yandex.net', 'sas5-9720.search.yandex.net', 'sas5-9729.search.yandex.net', 'sas5-9722.search.yandex.net', 'sas5-9726.search.yandex.net', 'sas5-9728.search.yandex.net', 'sas5-9724.search.yandex.net', 'sas5-9723.search.yandex.net', 'sas2-2921.search.yandex.net', 'sas5-8861.search.yandex.net', 'sas2-4968.search.yandex.net', 'sas2-4971.search.yandex.net', 'sas2-4967.search.yandex.net', 'sas2-4952.search.yandex.net', 'sas2-4966.search.yandex.net', 'sas2-4969.search.yandex.net', 'sas2-4973.search.yandex.net', 'sas2-4970.search.yandex.net', 'sas2-4953.search.yandex.net', 'sas3-5442.search.yandex.net', 'sas5-8199.search.yandex.net', 'sas5-8020.search.yandex.net', 'sas5-8155.search.yandex.net', 'sas5-8696.search.yandex.net', 'sas5-8697.search.yandex.net', 'sas3-9473.search.yandex.net', 'sas5-6162.search.yandex.net', 'sas5-6164.search.yandex.net', 'sas5-6161.search.yandex.net', 'sas5-6174.search.yandex.net', 'sas5-6175.search.yandex.net', 'sas3-2277.search.yandex.net', 'sas5-9969.search.yandex.net', 'sas5-9972.search.yandex.net', 'sas5-9967.search.yandex.net', 'sas5-9968.search.yandex.net', 'sas3-3179.search.yandex.net', 'sas4-3218.search.yandex.net', 'sas2-1251.search.yandex.net', 'sas5-9974.search.yandex.net', 'sas2-3007.search.yandex.net', 'sas2-3000.search.yandex.net', 'sas3-3175.search.yandex.net', 'sas2-2996.search.yandex.net', 'sas2-1909.search.yandex.net', 'sas3-8793.search.yandex.net', 'sas3-8789.search.yandex.net', 'sas2-1191.search.yandex.net', 'sas5-9734.search.yandex.net', 'sas5-8664.search.yandex.net', 'sas5-9725.search.yandex.net', 'sas0-8364.search.yandex.net', 'sas0-8367.search.yandex.net', 'sas5-8716.search.yandex.net', 'sas1-7381.search.yandex.net', 'sas2-1193.search.yandex.net', 'sas2-9365.search.yandex.net', 'sas2-2599.search.yandex.net', 'sas1-1817.search.yandex.net', 'sas2-3065.search.yandex.net', 'sas2-2913.search.yandex.net', 'sas2-9349.search.yandex.net', 'sas2-9346.search.yandex.net', 'sas4-6349.search.yandex.net', 'sas1-2346.search.yandex.net', 'sas2-0402.search.yandex.net', 'sas5-9510.search.yandex.net', 'sas3-2281.search.yandex.net', 'sas1-2156.search.yandex.net', 'sas3-5577.search.yandex.net', 'sas2-2848.search.yandex.net', 'sas3-2887.search.yandex.net', 'sas1-1979.search.yandex.net', 'sas4-6233.search.yandex.net', 'sas2-9357.search.yandex.net', 'sas3-2874.search.yandex.net', 'sas1-2433.search.yandex.net', 'sas1-2147.search.yandex.net', 'sas5-8717.search.yandex.net', 'sas3-2974.search.yandex.net', 'sas4-6359.search.yandex.net', 'sas3-2895.search.yandex.net', 'sas3-2922.search.yandex.net', 'sas5-1191.search.yandex.net', 'sas1-0419.search.yandex.net', 'sas5-1200.search.yandex.net', 'sas5-9520.search.yandex.net', 'sas2-1553.search.yandex.net', 'sas2-4649.search.yandex.net', 'sas3-8751.search.yandex.net', 'sas2-1552.search.yandex.net', 'sas5-9351.search.yandex.net', 'sas2-4978.search.yandex.net', 'sas5-9733.search.yandex.net', 'sas5-7240.search.yandex.net', 'sas3-1902.search.yandex.net', 'sas6-0204.search.yandex.net', 'sas6-0200.search.yandex.net', 'sas5-6176.search.yandex.net', 'sas2-2285.search.yandex.net', 'sas2-2602.search.yandex.net', 'sas2-2120.search.yandex.net', 'sas5-6177.search.yandex.net', 'sas5-7321.search.yandex.net', 'sas5-7231.search.yandex.net', 'sas2-2636.search.yandex.net', 'sas2-2892.search.yandex.net', 'sas2-2344.search.yandex.net', 'sas3-2308.search.yandex.net', 'sas2-4238.search.yandex.net', 'sas3-4510.search.yandex.net', 'sas3-9820.search.yandex.net', 'sas3-9803.search.yandex.net', 'sas2-4256.search.yandex.net', 'sas3-7445.search.yandex.net', 'sas5-8577.search.yandex.net', 'sas2-8553.search.yandex.net', 'sas2-8576.search.yandex.net', 'sas2-8559.search.yandex.net', 'sas2-8551.search.yandex.net', 'sas2-8570.search.yandex.net', 'sas2-8560.search.yandex.net', 'sas2-8573.search.yandex.net', 'sas5-9331.search.yandex.net', 'sas5-9321.search.yandex.net', 'sas2-4257.search.yandex.net', 'sas5-9327.search.yandex.net', 'sas3-9644.search.yandex.net', 'sas2-4247.search.yandex.net', 'sas2-4245.search.yandex.net', 'sas3-9844.search.yandex.net', 'sas2-4262.search.yandex.net', 'sas5-9163.search.yandex.net', 'sas3-4455.search.yandex.net', 'sas3-4382.search.yandex.net', 'sas3-4396.search.yandex.net', 'sas3-7514.search.yandex.net', 'sas3-4448.search.yandex.net', 'sas1-2585.search.yandex.net', 'sas3-4416.search.yandex.net', 'sas3-7508.search.yandex.net', 'sas5-8494.search.yandex.net', 'sas3-2293.search.yandex.net', 'sas3-1113.search.yandex.net', 'sas3-4343.search.yandex.net', 'sas2-1556.search.yandex.net', 'sas3-4379.search.yandex.net', 'sas4-3293.search.yandex.net', 'sas3-4413.search.yandex.net', 'sas3-7603.search.yandex.net', 'sas5-1188.search.yandex.net', 'sas5-8035.search.yandex.net', 'sas3-4341.search.yandex.net', 'sas3-4576.search.yandex.net', 'sas3-7097.search.yandex.net', 'sas2-1178.search.yandex.net', 'sas3-8697.search.yandex.net', 'sas4-3285.search.yandex.net', 'sas3-7598.search.yandex.net', 'sas3-4513.search.yandex.net', 'sas3-4376.search.yandex.net', 'sas4-6060.search.yandex.net', 'sas3-4566.search.yandex.net', 'sas3-4414.search.yandex.net', 'sas3-4347.search.yandex.net', 'sas3-6135.search.yandex.net', 'sas3-7454.search.yandex.net', 'sas3-4412.search.yandex.net', 'sas3-4398.search.yandex.net', 'sas4-5664.search.yandex.net', 'sas2-4020.search.yandex.net', 'sas3-4514.search.yandex.net', 'sas3-0981.search.yandex.net', 'sas3-7521.search.yandex.net', 'sas3-0984.search.yandex.net', 'sas3-4450.search.yandex.net', 'sas5-8568.search.yandex.net', 'sas3-4581.search.yandex.net', 'sas3-1023.search.yandex.net', 'sas3-3190.search.yandex.net', 'sas3-4423.search.yandex.net', 'sas3-4346.search.yandex.net', 'sas3-6154.search.yandex.net', 'sas4-5963.search.yandex.net', 'sas3-7453.search.yandex.net', 'sas3-4533.search.yandex.net', 'sas2-1554.search.yandex.net', 'sas3-7412.search.yandex.net', 'sas3-4427.search.yandex.net', 'sas3-4583.search.yandex.net', 'sas3-4440.search.yandex.net', 'sas2-1555.search.yandex.net', 'sas5-9544.search.yandex.net', 'sas5-9523.search.yandex.net', 'sas3-2914.search.yandex.net', 'sas3-7557.search.yandex.net', 'sas3-2127.search.yandex.net', 'sas3-2952.search.yandex.net', 'sas3-6200.search.yandex.net', 'sas3-2951.search.yandex.net', 'sas3-2888.search.yandex.net', 'sas3-2412.search.yandex.net', 'sas3-2379.search.yandex.net', 'sas3-2942.search.yandex.net', 'sas3-2940.search.yandex.net', 'sas3-2340.search.yandex.net', 'sas3-2856.search.yandex.net', 'sas3-2857.search.yandex.net', 'sas3-2893.search.yandex.net', 'sas3-2394.search.yandex.net', 'sas3-2865.search.yandex.net', 'sas3-2899.search.yandex.net', 'sas3-2959.search.yandex.net', 'sas3-2954.search.yandex.net', 'sas3-2926.search.yandex.net', 'sas3-2971.search.yandex.net', 'sas3-2393.search.yandex.net', 'sas3-2128.search.yandex.net', 'sas3-2371.search.yandex.net', 'sas3-1996.search.yandex.net', 'sas3-2991.search.yandex.net', 'sas3-2998.search.yandex.net', 'sas3-3011.search.yandex.net', 'sas5-9004.search.yandex.net', 'sas5-8451.search.yandex.net', 'sas2-1528.search.yandex.net', 'sas5-8109.search.yandex.net', 'sas3-3022.search.yandex.net', 'sas5-8064.search.yandex.net', 'sas5-7978.search.yandex.net', 'sas5-8383.search.yandex.net', 'sas5-8596.search.yandex.net', 'sas5-8247.search.yandex.net', 'sas5-9346.search.yandex.net', 'sas5-7813.search.yandex.net', 'sas5-7826.search.yandex.net', 'sas5-8958.search.yandex.net', 'sas5-7814.search.yandex.net', 'sas5-8268.search.yandex.net', 'sas5-8924.search.yandex.net', 'sas5-9046.search.yandex.net', 'sas5-8225.search.yandex.net', 'sas5-8773.search.yandex.net', 'sas5-9029.search.yandex.net', 'sas5-9277.search.yandex.net', 'sas2-9868.search.yandex.net', 'sas2-9822.search.yandex.net', 'sas2-9746.search.yandex.net', 'sas2-9824.search.yandex.net', 'sas2-9877.search.yandex.net', 'sas2-9820.search.yandex.net', 'sas2-9855.search.yandex.net', 'sas2-9846.search.yandex.net', 'sas3-6132.search.yandex.net', 'sas3-4524.search.yandex.net', 'sas2-9827.search.yandex.net', 'sas2-9834.search.yandex.net', 'sas2-9747.search.yandex.net', 'sas2-9843.search.yandex.net', 'sas2-9858.search.yandex.net', 'sas2-9841.search.yandex.net', 'sas5-8575.search.yandex.net', 'sas5-8045.search.yandex.net', 'sas5-7805.search.yandex.net', 'sas5-7801.search.yandex.net', 'sas5-9143.search.yandex.net', 'sas5-8353.search.yandex.net', 'sas2-9936.search.yandex.net', 'sas5-9125.search.yandex.net', 'sas5-7804.search.yandex.net', 'sas2-9939.search.yandex.net', 'sas5-7798.search.yandex.net', 'sas5-7821.search.yandex.net', 'sas5-8865.search.yandex.net', 'sas5-7831.search.yandex.net', 'sas5-7836.search.yandex.net', 'sas5-7834.search.yandex.net', 'sas5-5446.search.yandex.net', 'sas5-7830.search.yandex.net', 'sas5-9141.search.yandex.net', 'sas5-8300.search.yandex.net', 'sas5-8430.search.yandex.net', 'sas5-9278.search.yandex.net', 'sas5-7807.search.yandex.net', 'sas5-9246.search.yandex.net', 'sas5-8030.search.yandex.net', 'sas5-8070.search.yandex.net', 'sas5-8980.search.yandex.net', 'sas5-8874.search.yandex.net', 'sas5-9101.search.yandex.net', 'sas5-8385.search.yandex.net', 'sas5-8907.search.yandex.net', 'sas5-8588.search.yandex.net', 'sas5-8923.search.yandex.net', 'sas5-9049.search.yandex.net', 'sas5-9172.search.yandex.net', 'sas5-8333.search.yandex.net', 'sas5-8885.search.yandex.net', 'sas5-8492.search.yandex.net', 'sas5-8360.search.yandex.net', 'sas5-8185.search.yandex.net', 'sas5-8323.search.yandex.net', 'sas5-8267.search.yandex.net', 'sas5-8879.search.yandex.net', 'sas5-8303.search.yandex.net', 'sas5-8976.search.yandex.net', 'sas5-7808.search.yandex.net', 'sas5-9248.search.yandex.net', 'sas5-9193.search.yandex.net', 'sas5-8170.search.yandex.net', 'sas5-9042.search.yandex.net', 'sas5-8991.search.yandex.net', 'sas5-7812.search.yandex.net', 'sas5-8044.search.yandex.net', 'sas5-8332.search.yandex.net', 'sas5-9303.search.yandex.net', 'sas5-8317.search.yandex.net', 'sas5-8412.search.yandex.net', 'sas5-9730.search.yandex.net', 'sas5-7970.search.yandex.net', 'sas5-9066.search.yandex.net', 'sas5-8284.search.yandex.net', 'sas5-8996.search.yandex.net', 'sas5-8431.search.yandex.net', 'sas5-9016.search.yandex.net', 'sas5-7938.search.yandex.net', 'sas5-8965.search.yandex.net', 'sas5-9134.search.yandex.net', 'sas5-9011.search.yandex.net', 'sas5-9203.search.yandex.net', 'sas5-8939.search.yandex.net', 'sas5-8043.search.yandex.net', 'sas5-8192.search.yandex.net', 'sas5-8198.search.yandex.net', 'sas5-8023.search.yandex.net', 'sas5-8498.search.yandex.net', 'sas5-7333.search.yandex.net', 'sas5-7332.search.yandex.net', 'sas5-7334.search.yandex.net', 'sas5-8108.search.yandex.net', 'sas5-9292.search.yandex.net', 'sas5-9257.search.yandex.net', 'sas5-9273.search.yandex.net', 'sas5-8893.search.yandex.net', 'sas5-9088.search.yandex.net', 'sas5-8007.search.yandex.net', 'sas5-8223.search.yandex.net', 'sas5-7959.search.yandex.net', 'sas5-8576.search.yandex.net', 'sas5-8120.search.yandex.net', 'sas5-7976.search.yandex.net', 'sas5-9113.search.yandex.net', 'sas5-9014.search.yandex.net', 'sas5-8150.search.yandex.net', 'sas5-8013.search.yandex.net', 'sas5-8141.search.yandex.net', 'sas5-9280.search.yandex.net', 'sas5-9035.search.yandex.net', 'sas5-8384.search.yandex.net', 'sas5-8483.search.yandex.net', 'sas5-8024.search.yandex.net', 'sas5-8318.search.yandex.net', 'sas5-8222.search.yandex.net', 'sas0-6541.search.yandex.net', 'sas0-6542.search.yandex.net', 'sas5-8662.search.yandex.net', 'sas5-8661.search.yandex.net', 'sas5-8046.search.yandex.net', 'sas5-8188.search.yandex.net', 'sas5-8176.search.yandex.net', 'sas5-7816.search.yandex.net', 'sas5-8031.search.yandex.net', 'sas5-8512.search.yandex.net', 'sas5-9130.search.yandex.net', 'sas5-8388.search.yandex.net', 'sas5-8290.search.yandex.net', 'sas3-3458.search.yandex.net', 'sas3-5594.search.yandex.net', 'sas3-3434.search.yandex.net', 'sas3-3225.search.yandex.net', 'sas5-8918.search.yandex.net', 'sas3-8695.search.yandex.net', 'sas3-8748.search.yandex.net', 'sas4-3435.search.yandex.net', 'sas5-3967.search.yandex.net', 'sas5-8003.search.yandex.net', 'sas5-9314.search.yandex.net', 'sas5-3965.search.yandex.net', 'sas5-8602.search.yandex.net', 'sas5-8001.search.yandex.net', 'sas5-9038.search.yandex.net', 'sas5-8246.search.yandex.net', 'sas5-8920.search.yandex.net', 'sas5-9348.search.yandex.net', 'sas5-8449.search.yandex.net', 'sas5-7948.search.yandex.net', 'sas5-8174.search.yandex.net', 'sas5-9296.search.yandex.net', 'sas5-8293.search.yandex.net', 'sas3-3352.search.yandex.net', 'sas5-9243.search.yandex.net', 'sas5-8154.search.yandex.net', 'sas5-8365.search.yandex.net', 'sas5-9123.search.yandex.net', 'sas5-8348.search.yandex.net', 'sas5-8429.search.yandex.net', 'sas5-8574.search.yandex.net', 'sas5-8984.search.yandex.net', 'sas2-5418.search.yandex.net', 'sas3-3421.search.yandex.net', 'sas3-8744.search.yandex.net', 'sas3-8708.search.yandex.net', 'sas3-8712.search.yandex.net', 'sas3-8709.search.yandex.net', 'sas3-8698.search.yandex.net', 'sas3-8767.search.yandex.net', 'sas3-8745.search.yandex.net', 'sas2-5330.search.yandex.net', 'sas2-5342.search.yandex.net', 'sas3-7628.search.yandex.net', 'sas2-5472.search.yandex.net', 'sas3-7660.search.yandex.net', 'sas3-7650.search.yandex.net', 'sas3-8716.search.yandex.net', 'sas2-5475.search.yandex.net', 'sas2-5452.search.yandex.net', 'sas3-8710.search.yandex.net', 'sas3-8717.search.yandex.net', 'sas3-8718.search.yandex.net', 'sas3-8711.search.yandex.net', 'sas3-8768.search.yandex.net', 'sas3-8757.search.yandex.net', 'sas3-8714.search.yandex.net', 'sas2-5347.search.yandex.net', 'sas2-5848.search.yandex.net', 'sas2-5431.search.yandex.net', 'sas3-7672.search.yandex.net', 'sas3-7646.search.yandex.net', 'sas2-3055.search.yandex.net', 'sas3-7630.search.yandex.net', 'sas5-8158.search.yandex.net', 'sas5-8285.search.yandex.net', 'sas5-8496.search.yandex.net', 'sas5-7958.search.yandex.net', 'sas5-9080.search.yandex.net', 'sas5-8266.search.yandex.net', 'sas5-7819.search.yandex.net', 'sas5-9251.search.yandex.net', 'sas5-9306.search.yandex.net', 'sas3-2385.search.yandex.net', 'sas5-8081.search.yandex.net', 'sas5-8390.search.yandex.net', 'sas5-9267.search.yandex.net', 'sas5-9219.search.yandex.net', 'sas5-9098.search.yandex.net', 'sas5-7963.search.yandex.net', 'sas5-8477.search.yandex.net', 'sas2-5482.search.yandex.net', 'sas3-7435.search.yandex.net', 'sas2-1511.search.yandex.net', 'sas5-9076.search.yandex.net', 'sas3-4523.search.yandex.net', 'sas2-9095.search.yandex.net', 'sas2-9059.search.yandex.net', 'sas3-7426.search.yandex.net', 'sas2-9056.search.yandex.net', 'sas2-1531.search.yandex.net', 'sas2-9057.search.yandex.net', 'sas2-9105.search.yandex.net', 'sas2-9053.search.yandex.net', 'sas2-9058.search.yandex.net', 'sas2-1510.search.yandex.net', 'sas2-9109.search.yandex.net', 'sas2-9060.search.yandex.net', 'sas2-9110.search.yandex.net', 'sas2-1524.search.yandex.net', 'sas5-9235.search.yandex.net', 'sas5-7833.search.yandex.net', 'sas5-8931.search.yandex.net', 'sas5-9148.search.yandex.net', 'sas3-0541.search.yandex.net', 'sas3-3174.search.yandex.net', 'sas2-9111.search.yandex.net', 'sas2-9954.search.yandex.net', 'sas3-5562.search.yandex.net', 'sas3-2124.search.yandex.net', 'sas3-8759.search.yandex.net', 'sas3-8713.search.yandex.net', 'sas3-8720.search.yandex.net', 'sas2-9114.search.yandex.net', 'sas2-9042.search.yandex.net', 'sas2-9112.search.yandex.net', 'sas2-9096.search.yandex.net', 'sas3-7633.search.yandex.net', 'sas2-9064.search.yandex.net', 'sas2-9113.search.yandex.net', 'sas2-9061.search.yandex.net', 'sas2-9099.search.yandex.net', 'sas2-9063.search.yandex.net', 'sas2-9086.search.yandex.net', 'sas2-1536.search.yandex.net', 'sas3-7534.search.yandex.net', 'sas2-9101.search.yandex.net', 'sas2-9065.search.yandex.net', 'sas2-9094.search.yandex.net', 'sas2-9072.search.yandex.net', 'sas3-4575.search.yandex.net', 'sas2-9844.search.yandex.net', 'sas2-9750.search.yandex.net', 'sas3-6083.search.yandex.net', 'sas2-9851.search.yandex.net', 'sas2-9838.search.yandex.net', 'sas2-9945.search.yandex.net', 'sas2-9853.search.yandex.net', 'sas2-9821.search.yandex.net', 'sas2-9751.search.yandex.net', 'sas2-9825.search.yandex.net', 'sas2-1523.search.yandex.net', 'sas2-9818.search.yandex.net', 'sas2-9847.search.yandex.net', 'sas2-9837.search.yandex.net', 'sas2-9839.search.yandex.net', 'sas2-9943.search.yandex.net', 'sas2-9753.search.yandex.net', 'sas2-9840.search.yandex.net', 'sas2-9833.search.yandex.net', 'sas3-7693.search.yandex.net', 'sas3-6037.search.yandex.net', 'sas5-8069.search.yandex.net', 'sas3-7473.search.yandex.net', 'sas4-5847.search.yandex.net', 'sas3-7415.search.yandex.net', 'sas3-4567.search.yandex.net', 'sas3-4521.search.yandex.net', 'sas3-4580.search.yandex.net', 'sas5-8050.search.yandex.net', 'sas3-4512.search.yandex.net', 'sas3-4569.search.yandex.net', 'sas5-5442.search.yandex.net', 'sas5-7835.search.yandex.net', 'sas5-7806.search.yandex.net', 'sas5-7839.search.yandex.net', 'sas5-7829.search.yandex.net', 'sas5-9731.search.yandex.net', 'sas5-5447.search.yandex.net', 'sas5-8578.search.yandex.net', 'sas5-9139.search.yandex.net', 'sas5-8406.search.yandex.net', 'sas5-7820.search.yandex.net', 'sas5-8866.search.yandex.net', 'sas5-8470.search.yandex.net', 'sas5-8507.search.yandex.net', 'sas5-8501.search.yandex.net', 'sas5-8306.search.yandex.net', 'sas5-8891.search.yandex.net', 'sas5-7822.search.yandex.net', 'sas5-7997.search.yandex.net', 'sas5-8316.search.yandex.net', 'sas5-8543.search.yandex.net', 'sas5-8912.search.yandex.net', 'sas5-9328.search.yandex.net', 'sas5-7999.search.yandex.net', 'sas5-8881.search.yandex.net', 'sas5-8892.search.yandex.net', 'sas5-8426.search.yandex.net', 'sas5-8609.search.yandex.net', 'sas5-8156.search.yandex.net', 'sas5-9040.search.yandex.net', 'sas5-9279.search.yandex.net', 'sas5-8961.search.yandex.net', 'sas5-9031.search.yandex.net', 'sas5-8391.search.yandex.net', 'sas5-8527.search.yandex.net', 'sas5-8193.search.yandex.net', 'sas5-9152.search.yandex.net', 'sas5-8476.search.yandex.net', 'sas5-8906.search.yandex.net', 'sas5-8040.search.yandex.net', 'sas2-9752.search.yandex.net', 'sas5-9052.search.yandex.net', 'sas5-8334.search.yandex.net', 'sas5-9216.search.yandex.net', 'sas5-8328.search.yandex.net', 'sas5-8414.search.yandex.net', 'sas5-8039.search.yandex.net', 'sas5-8061.search.yandex.net', 'sas5-9043.search.yandex.net', 'sas5-8248.search.yandex.net', 'sas5-8545.search.yandex.net', 'sas5-8356.search.yandex.net', 'sas5-8152.search.yandex.net', 'sas5-9087.search.yandex.net', 'sas5-9107.search.yandex.net', 'sas5-8528.search.yandex.net', 'sas5-8237.search.yandex.net', 'sas5-8302.search.yandex.net', 'sas5-8265.search.yandex.net', 'sas5-8886.search.yandex.net', 'sas5-8872.search.yandex.net', 'sas5-8601.search.yandex.net', 'sas5-8357.search.yandex.net', 'sas4-5988.search.yandex.net', 'sas4-7302.search.yandex.net', 'sas4-5645.search.yandex.net', 'sas5-8657.search.yandex.net', 'sas1-9757.search.yandex.net', 'sas1-2153.search.yandex.net', 'sas4-6168.search.yandex.net', 'sas1-2400.search.yandex.net', 'sas1-2339.search.yandex.net', 'sas1-1994.search.yandex.net', 'sas3-9675.search.yandex.net', 'sas2-7702.search.yandex.net', 'sas2-4724.search.yandex.net', 'sas2-8552.search.yandex.net', 'sas2-8574.search.yandex.net', 'sas2-8562.search.yandex.net', 'sas2-8575.search.yandex.net', 'sas2-8566.search.yandex.net', 'sas2-8554.search.yandex.net', 'sas2-8567.search.yandex.net', 'sas2-8565.search.yandex.net', 'sas2-8579.search.yandex.net', 'sas2-8564.search.yandex.net', 'sas2-8555.search.yandex.net', 'sas2-8569.search.yandex.net', 'sas2-8561.search.yandex.net', 'sas2-8578.search.yandex.net', 'sas2-8563.search.yandex.net', 'sas3-9640.search.yandex.net', 'sas3-9804.search.yandex.net', 'sas3-9807.search.yandex.net', 'sas3-9822.search.yandex.net', 'sas2-8583.search.yandex.net', 'sas2-8571.search.yandex.net', 'sas2-8568.search.yandex.net', 'sas3-9805.search.yandex.net', 'sas3-9642.search.yandex.net', 'sas2-4243.search.yandex.net', 'sas3-7466.search.yandex.net', 'sas0-3814.search.yandex.net', 'sas3-9808.search.yandex.net', 'sas3-9819.search.yandex.net', 'sas3-9811.search.yandex.net', 'sas3-7583.search.yandex.net', 'sas0-3815.search.yandex.net', 'sas3-9809.search.yandex.net', 'sas0-3810.search.yandex.net', 'sas0-3812.search.yandex.net', 'sas3-4568.search.yandex.net', 'sas2-4698.search.yandex.net', 'sas0-3813.search.yandex.net', 'sas3-5775.search.yandex.net', 'sas3-4520.search.yandex.net', 'sas3-9821.search.yandex.net', 'sas2-4242.search.yandex.net', 'sas5-9033.search.yandex.net', 'sas2-4718.search.yandex.net', 'sas3-7696.search.yandex.net', 'sas3-4531.search.yandex.net', 'sas3-4518.search.yandex.net', 'sas2-4741.search.yandex.net', 'sas3-4517.search.yandex.net', 'sas3-7485.search.yandex.net', 'sas5-8135.search.yandex.net', 'sas3-4579.search.yandex.net', 'sas3-5057.search.yandex.net', 'sas3-6131.search.yandex.net', 'sas5-8402.search.yandex.net', 'sas2-4738.search.yandex.net', 'sas3-6017.search.yandex.net', 'sas5-9320.search.yandex.net', 'sas3-7449.search.yandex.net', 'sas3-9645.search.yandex.net', 'sas2-4248.search.yandex.net', 'sas3-6059.search.yandex.net', 'sas3-4600.search.yandex.net', 'sas2-4260.search.yandex.net', 'sas3-9843.search.yandex.net', 'sas3-4511.search.yandex.net', 'sas3-9641.search.yandex.net', 'sas3-9812.search.yandex.net', 'sas3-9841.search.yandex.net', 'sas2-4704.search.yandex.net', 'sas3-9842.search.yandex.net', 'sas5-8340.search.yandex.net', 'sas3-9643.search.yandex.net', 'sas5-9360.search.yandex.net', 'sas2-4258.search.yandex.net', 'sas3-9850.search.yandex.net', 'sas3-9823.search.yandex.net', 'sas5-9324.search.yandex.net', 'sas3-9853.search.yandex.net', 'sas2-1537.search.yandex.net', 'sas3-4565.search.yandex.net', 'sas3-4606.search.yandex.net', 'sas3-4560.search.yandex.net', 'sas3-4522.search.yandex.net', 'sas2-4742.search.yandex.net', 'sas2-4695.search.yandex.net', 'sas2-4722.search.yandex.net', 'sas2-4747.search.yandex.net', 'sas2-4720.search.yandex.net', 'sas2-4732.search.yandex.net', 'sas2-4694.search.yandex.net', 'sas2-4726.search.yandex.net', 'sas3-5065.search.yandex.net', 'sas3-4875.search.yandex.net', 'sas5-8131.search.yandex.net', 'sas3-7588.search.yandex.net', 'sas3-4584.search.yandex.net', 'sas3-6020.search.yandex.net', 'sas3-7497.search.yandex.net', 'sas5-9168.search.yandex.net', 'sas3-6079.search.yandex.net', 'sas5-8111.search.yandex.net', 'sas2-4752.search.yandex.net', 'sas2-4723.search.yandex.net', 'sas3-4604.search.yandex.net', 'sas2-4751.search.yandex.net', 'sas3-7409.search.yandex.net', 'sas3-4561.search.yandex.net', 'sas3-7511.search.yandex.net', 'sas3-4998.search.yandex.net', 'sas5-9110.search.yandex.net', 'sas3-4562.search.yandex.net', 'sas3-7502.search.yandex.net', 'sas3-4610.search.yandex.net', 'sas3-5995.search.yandex.net', 'sas3-7529.search.yandex.net', 'sas5-7957.search.yandex.net', 'sas3-4574.search.yandex.net', 'sas3-4602.search.yandex.net', 'sas3-4582.search.yandex.net', 'sas3-7455.search.yandex.net', 'sas3-4519.search.yandex.net', 'sas3-7608.search.yandex.net', 'sas3-4532.search.yandex.net', 'sas3-9701.search.yandex.net', 'sas3-7572.search.yandex.net', 'sas3-7093.search.yandex.net', 'sas2-4745.search.yandex.net', 'sas3-4603.search.yandex.net', 'sas3-5068.search.yandex.net', 'sas3-4534.search.yandex.net', 'sas3-6205.search.yandex.net', 'sas2-4254.search.yandex.net', 'sas5-9161.search.yandex.net', 'sas3-4601.search.yandex.net', 'sas3-9702.search.yandex.net', 'sas3-5109.search.yandex.net', 'sas3-9824.search.yandex.net', 'sas3-4578.search.yandex.net', 'sas3-7704.search.yandex.net', 'sas2-4757.search.yandex.net', 'sas3-4563.search.yandex.net', 'sas3-7483.search.yandex.net', 'sas3-5116.search.yandex.net', 'sas5-8011.search.yandex.net', 'sas3-6031.search.yandex.net', 'sas3-4515.search.yandex.net', 'sas3-7490.search.yandex.net', 'sas3-4884.search.yandex.net', 'sas5-8462.search.yandex.net', 'sas5-8875.search.yandex.net', 'sas3-9639.search.yandex.net', 'sas3-6211.search.yandex.net', 'sas3-7506.search.yandex.net', 'sas3-7494.search.yandex.net', 'sas3-7679.search.yandex.net', 'sas3-4535.search.yandex.net', 'sas3-5066.search.yandex.net', 'sas5-8950.search.yandex.net', 'sas3-4570.search.yandex.net', 'sas3-4538.search.yandex.net', 'sas3-4577.search.yandex.net', 'sas3-4907.search.yandex.net', 'sas3-4564.search.yandex.net', 'sas3-9684.search.yandex.net', 'sas3-7750.search.yandex.net', 'sas3-9855.search.yandex.net', 'sas3-7684.search.yandex.net', 'sas3-4516.search.yandex.net', 'sas5-8151.search.yandex.net', 'sas3-7616.search.yandex.net', 'sas2-4736.search.yandex.net', 'sas3-7746.search.yandex.net', 'sas5-8606.search.yandex.net', 'sas3-4599.search.yandex.net', 'sas3-4539.search.yandex.net', 'sas3-5626.search.yandex.net', 'sas3-4548.search.yandex.net', 'sas3-5666.search.yandex.net', 'sas3-7606.search.yandex.net', 'sas3-5073.search.yandex.net', 'sas3-4540.search.yandex.net', 'sas5-9268.search.yandex.net', 'sas3-4880.search.yandex.net', 'sas3-4895.search.yandex.net', 'sas3-4525.search.yandex.net', 'sas3-4543.search.yandex.net', 'sas5-8418.search.yandex.net', 'sas5-8181.search.yandex.net', 'sas3-4607.search.yandex.net', 'sas3-7688.search.yandex.net', 'sas3-5075.search.yandex.net', 'sas3-6192.search.yandex.net', 'sas5-9275.search.yandex.net', 'sas3-9683.search.yandex.net', 'sas3-7551.search.yandex.net', 'sas3-7476.search.yandex.net', 'sas5-8994.search.yandex.net', 'sas3-9686.search.yandex.net', 'sas3-4527.search.yandex.net', 'sas3-7549.search.yandex.net', 'sas5-9020.search.yandex.net', 'sas3-7596.search.yandex.net', 'sas3-7519.search.yandex.net', 'sas5-8372.search.yandex.net', 'sas3-4896.search.yandex.net', 'sas3-4526.search.yandex.net', 'sas5-9341.search.yandex.net', 'sas3-4588.search.yandex.net', 'sas3-7518.search.yandex.net', 'sas3-5072.search.yandex.net', 'sas3-9674.search.yandex.net', 'sas5-9128.search.yandex.net', 'sas3-5631.search.yandex.net', 'sas3-4528.search.yandex.net', 'sas3-4529.search.yandex.net', 'sas3-7467.search.yandex.net', 'sas3-4550.search.yandex.net', 'sas3-4724.search.yandex.net', 'sas3-9817.search.yandex.net', 'sas3-4551.search.yandex.net', 'sas3-6112.search.yandex.net', 'sas3-4590.search.yandex.net', 'sas3-4924.search.yandex.net', 'sas3-5074.search.yandex.net', 'sas3-9831.search.yandex.net', 'sas3-7434.search.yandex.net', 'sas5-9145.search.yandex.net', 'sas3-4591.search.yandex.net', 'sas3-4536.search.yandex.net', 'sas3-4711.search.yandex.net', 'sas3-4983.search.yandex.net', 'sas3-7469.search.yandex.net', 'sas3-4530.search.yandex.net', 'sas3-4573.search.yandex.net', 'sas3-4549.search.yandex.net', 'sas3-7605.search.yandex.net', 'sas3-4593.search.yandex.net', 'sas5-8173.search.yandex.net', 'sas3-4715.search.yandex.net', 'sas3-6128.search.yandex.net', 'sas3-7587.search.yandex.net', 'sas3-7520.search.yandex.net', 'sas5-7950.search.yandex.net', 'sas3-9638.search.yandex.net', 'sas3-6089.search.yandex.net', 'sas3-9830.search.yandex.net', 'sas3-7482.search.yandex.net', 'sas2-4719.search.yandex.net', 'sas5-7996.search.yandex.net', 'sas3-5819.search.yandex.net', 'sas3-4714.search.yandex.net', 'sas3-7619.search.yandex.net'])"
        val: "yp-sas-10pct"
      - exp: "prj('rtc-testing')"
        val: "rtc-resting"
      - exp: "prj('yp-iss-vla-noclab')"
        val: "yp-iss-vla-noclab"
      - exp: "prj('yp-iss-vla-yt-arnold-rnd')"
        val: "yp-iss-vla-yt-arnold-rnd"
      - exp: "prj(['yp-prestable-rnd', 'yp-iss-prestable'])"
        val: "yp-prestable"
      - exp: "prj('yp-iss-sas-base-search-prestable')"
        val: "yp-iss-sas-base-search-prestable"
      - exp: "prj('yp-gpu-sas-dev-prestable')"
        val: yp-gpu-sas-dev-prestable
      - exp: "prj(['yp-iss-sas-yt-hahn-gpu-bert', 'yp-iss-man-yt-hahn-gpu-bert'])"
        val: bert
      - exp: "prj(['yp-iss-sas-yt-hahn-gpu-yati2', 'yp-iss-vla-yt-hahn-gpu-yati3'])"
        val: yati2-yati3
      - exp: "prj(['yp-gpu-iva-dev', 'yp-gpu-man-dev', 'yp-gpu-myt-dev', 'yp-gpu-sas-dev', 'yp-gpu-vla-dev']) && (cpu_model == 'AMD EPYC 7702 64-Core Processor' || cpu_model == 'AMD EPYC 7662 64-Core Processor' || cpu_model.startsWith('Intel(R) Xeon(R) Gold 6338 CPU'))"
        val: gpu-dev-n4
      - exp: "prj(['yp-gpu-iva-dev', 'yp-gpu-man-dev', 'yp-gpu-myt-dev', 'yp-gpu-sas-dev', 'yp-gpu-vla-dev'])"
        val: gpu-dev
      - exp: "prj(['yp-iss-sas-distbuild', 'yp-iss-man-distbuild', 'yp-iss-vla-distbuild'])"
        val: yp-distbuild
      - exp: "has_tag('rtc.stage-experiment') && cpu_model.contains('AMD')"
        val: exp-amd
      - exp: "has_tag('rtc.stage-experiment') && has_tag(['rtc.gpu-nvidia', 'rtc.gpu-vfio'])"
        val: exp-gpu
      - exp: "has_tag('rtc.stage-experiment')"
        val: exp
      - exp: "has_tag('rtc.stage-prestable') && cpu_model.contains('AMD')"
        val: prestable-amd
      - exp: "has_tag('rtc.stage-prestable') && has_tag(['rtc.gpu-nvidia', 'rtc.gpu-vfio'])"
        val: prestable-gpu
      - exp: "has_tag('rtc.stage-prestable') && has_tag('rtc.yt_cluster-hume')"
        val: yt-hume
      - exp: "has_tag('rtc.stage-prestable') && has_tag('rtc.yt_cluster-socrates')"
        val: yt-socrates
      - exp: "has_tag('rtc.stage-prestable') && has_tag('rtc.yt_cluster-freud')"
        val: yt-freud
      - exp: "has_tag('rtc.stage-prestable') && has_tag('rtc.yt_cluster-ada')"
        val: yt-ada
      - exp: "has_tag('rtc.stage-prestable') && has_tag('rtc.yt_cluster-zeno')"
        val: yt-zeno
      - exp: "has_tag('rtc.stage-prestable')"
        val: prestable
      - exp: "has_tag('rtc.stage-core')"
        val: core
      # !expression violates recommended selector order!
      - exp: "cpu_model == 'AMD EPYC 7702 64-Core Processor' || cpu_model == 'AMD EPYC 7662 64-Core Processor' || cpu_model.startsWith('Intel(R) Xeon(R) Gold 6338 CPU')"
        val: epyc-7702-7662-intel-6338
      - exp: "has_tag(['rtc.gpu-nvidia', 'rtc.gpu-vfio']) && cpu_model.contains('AMD')"
        val: gpu-amd
      - exp: "has_tag(['rtc.gpu-nvidia', 'rtc.gpu-vfio']) && has_tag('rtc.reboot_segment-yt-hahn')"
        val: gpu-hahn
      - exp: "has_tag(['rtc.gpu-nvidia', 'rtc.gpu-vfio']) && has_tag('rtc.reboot_segment-yt-arnold')"
        val: gpu-arnold
      - exp: has_tag(['rtc.gpu-nvidia', 'rtc.gpu-vfio'])
        val: gpu
      - exp: "has_tag('rtc.reboot_segment-yt_masters') && has_tag('rtc.yt_cluster-ada')"
        val: yt-ada-masters
      - exp: "has_tag('rtc.reboot_segment-yt_masters') && has_tag('rtc.yt_cluster-arnold')"
        val: yt-arnold-masters
      - exp: "has_tag('rtc.reboot_segment-yt_masters') && has_tag('rtc.yt_cluster-bohr')"
        val: yt-bohr-masters
      - exp: "has_tag('rtc.reboot_segment-yt_masters') && has_tag('rtc.yt_cluster-freud')"
        val: yt-freud-masters
      - exp: "has_tag('rtc.reboot_segment-yt_masters') && has_tag('rtc.yt_cluster-hahn')"
        val: yt-hahn-masters
      - exp: "has_tag('rtc.reboot_segment-yt_masters') && has_tag('rtc.yt_cluster-hume')"
        val: yt-hume-masters
      - exp: "has_tag('rtc.reboot_segment-yt_masters') && has_tag('rtc.yt_cluster-landau')"
        val: yt-landau-masters
      - exp: "has_tag('rtc.reboot_segment-yt_masters') && has_tag('rtc.yt_cluster-locke')"
        val: yt-locke-masters
      - exp: "has_tag('rtc.reboot_segment-yt_masters') && has_tag('rtc.yt_cluster-markov')"
        val: yt-markov-masters
      - exp: "has_tag('rtc.reboot_segment-yt_masters') && has_tag('rtc.yt_cluster-pythia')"
        val: yt-pythia-masters
      - exp: "has_tag('rtc.reboot_segment-yt_masters') && has_tag('rtc.yt_cluster-seneca_man')"
        val: yt-seneca_man-masters
      - exp: "has_tag('rtc.reboot_segment-yt_masters') && has_tag('rtc.yt_cluster-seneca_sas')"
        val: yt-seneca_sas-masters
      - exp: "has_tag('rtc.reboot_segment-yt_masters') && has_tag('rtc.yt_cluster-seneca_vla')"
        val: yt-seneca_vla-masters
      - exp: "has_tag('rtc.reboot_segment-yt_masters') && has_tag('rtc.yt_cluster-socrates')"
        val: yt-socrates-masters
      - exp: "has_tag('rtc.reboot_segment-yt_masters') && has_tag('rtc.yt_cluster-vanga')"
        val: yt-vanga-masters
      - exp: "has_tag('rtc.reboot_segment-yt_masters') && has_tag('rtc.yt_cluster-zeno')"
        val: yt-zeno-masters
      - exp: "has_tag('rtc.reboot_segment-yt_masters')"
        val: yt-masters
      - exp: "has_tag('rtc.reboot_segment-yp_masters')"
        val: yp-masters
      - exp: "has_tag('yp_dev')"
        val: yp-dev
      - exp: "has_tag('rtc.reboot_segment-yt-socrates')"
        val: yt-socrates
      - exp: "has_tag('rtc.reboot_segment-yt-bohr')"
        val: yt-bohr
      - exp: "has_tag('rtc.reboot_segment-yt-landau')"
        val: yt-landau
      - exp: "has_tag('rtc.reboot_segment-yt-markov')"
        val: yt-markov
      - exp: "has_tag('rtc.reboot_segment-yt-seneca')"
        val: yt-seneca
      - exp: "has_tag('rtc.reboot_segment-yt-vanga')"
        val: yt-vanga
      - exp: "has_tag('rtc.reboot_segment-yt-ofd-xdc')"
        val: yt-ofd-xdc
      - exp: "has_tag('rtc.reboot_segment-yt-locke')"
        val: yt-locke
      - exp: "has_tag('rtc.reboot_segment-yt-arnold')"
        val: yt-arnold
      - exp: "has_tag('rtc.reboot_segment-yt-hahn')"
        val: yt-hahn
      - exp: "has_tag('rtc.reboot_segment-qloud')"
        val: qloud
      - exp: "has_tag('rtc.reboot_segment-sandbox')"
        val: sandbox
      - exp: "has_tag('rtc.reboot_segment-distbuild')"
        val: distbuild
      - exp: "has_tag('rtc.reboot_segment-incoming')"
        val: incoming
      - exp: "has_tag('rtc.reboot_segment-market')"
        val: market
      - exp: "has_tag('rtc.reboot_segment-yabs')"
        val: yabs
      - exp: "default()"
        val: default

  - name: ver
    match:
      - exp: "stage == 'ebpf-demo'"
        val: "4.19.119-30.2"
      - exp: "stage == 'KERNEL-519-exp'"
        val: "5.4.112-15.3"
      - exp: "stage == 'RTCNETWORK-628-exp'"
        val: "5.4.80-6.1"
      - exp: "stage == 'RTCNETWORK-699-exp'"
        val: "5.4.105-11"
      - exp: "stage == 'RTCNETWORK-763-exp'"
        val: "5.4.112-15.3"
      - exp: "stage == 'RUNTIMECLOUD-18353-exp'"
        val: "5.4.112-15.3"
      - exp: "stage == 'HOSTMAN-975-exp'"
        val: "5.4.105-11"
      - exp: "stage == 'HOSTMAN-975-test'"
        val: "5.4.105-11"
      - exp: "stage == 'yp-sas-10pct'"
        val: "5.4.112-15.3"
      - exp: "stage == 'rtc-resting'"
        val: "4.4.171-70.1"
      - exp: "stage == 'yp-iss-vla-noclab'"
        val: "4.19.183-42"
      - exp: "stage == 'yp-iss-vla-yt-arnold-rnd'"
        val: "5.4.123-16"
      - exp: "stage == 'yp-prestable'"
        val: "5.4.112-15"
      - exp: "stage == 'yp-iss-sas-base-search-prestable'"
        val: "5.4.123-16"
      - exp: "stage == 'yp-gpu-sas-dev-prestable'"
        val: "5.4.80-6.1"
      - exp: "stage == 'bert'"
        val: "5.4.80-6.1"
      - exp: "stage == 'yati2-yati3'"
        val: "5.4.112-15.1bert"
      - exp: "stage == 'gpu-dev-n4'"
        val: "5.4.112-15.3"
      - exp: "stage == 'gpu-dev'"
        val: "5.4.80-6.1"
      - exp: "stage == 'exp-amd'"
        val: "5.4.123-16"
      - exp: "stage == 'exp-gpu'"
        val: "5.4.123-16"
      - exp: "stage == 'exp'"
        val: "5.4.123-16"
      - exp: "stage == 'prestable-amd'"
        val: "4.19.196-46"
      - exp: "stage == 'prestable-gpu'"
        val: "4.19.196-46"
      - exp: "stage == 'yt-hume'"
        val: "5.4.123-16"
      - exp: "stage == 'yt-socrates'"
        val: "5.4.112-15"
      - exp: "stage == 'yt-freud'"
        val: "5.4.112-15"
      - exp: "stage == 'yt-ada'"
        val: "5.4.110-13"
      - exp: "stage == 'yt-zeno'"
        val: "5.4.112-15"
      - exp: "stage == 'prestable'"
        val: "4.19.196-46"
      - exp: "stage == 'core'"
        val: "4.19.119-30.2"
      - exp: "stage == 'epyc-7702-7662-intel-6338'"
        val: "5.4.112-15.3"
      - exp: "stage == 'gpu-amd'"
        val: "4.19.119-30.2"
      - exp: "stage == 'gpu-hahn'"
        val: "4.19.119-30.2"
      - exp: "stage == 'gpu-arnold'"
        val: "4.19.119-30.2"
      - exp: "stage == 'gpu'"
        val: "4.19.119-30.2"
      - exp: "stage == 'yt-ada-masters'"
        val: "4.19.119-30.2"
      - exp: "stage == 'yt-arnold-masters'"
        val: "4.19.119-30.2"
      - exp: "stage == 'yt-bohr-masters'"
        val: "4.19.119-30.2"
      - exp: "stage == 'yt-freud-masters'"
        val: "5.4.112-15"
      - exp: "stage == 'yt-hahn-masters'"
        val: "4.19.119-30.2"
      - exp: "stage == 'yt-hume-masters'"
        val: "5.4.112-15"
      - exp: "stage == 'yt-landau-masters'"
        val: "4.19.119-30.2"
      - exp: "stage == 'yt-locker-masters'"
        val: "4.19.119-30.2"
      - exp: "stage == 'yt-markov-masters'"
        val: "4.19.119-30.2"
      - exp: "stage == 'yt-pythia-masters'"
        val: "4.19.119-30.2"
      - exp: "stage == 'yt-ofd-masters'"
        val: "4.19.119-30.2"
      - exp: "stage == 'yt-seneca_man-masters'"
        val: "4.19.119-30.2"
      - exp: "stage == 'yt-seneca_sas-masters'"
        val: "4.19.119-30.2"
      - exp: "stage == 'yt-seneca_vla-masters'"
        val: "4.19.119-30.2"
      - exp: "stage == 'yt-socrates-masters'"
        val: "4.19.119-30.2"
      - exp: "stage == 'yt-vanga-masters'"
        val: "4.19.119-30.2"
      - exp: "stage == 'yt-zeno-masters'"
        val: "4.19.119-30.2"
      - exp: "stage == 'yt-masters'"
        val: "4.19.119-30.2"
      - exp: "stage == 'yp-masters'"
        val: "4.19.119-30.2"
      - exp: "stage == 'yp-dev'"
        val: "4.19.119-30.2"
      - exp: "stage == 'yt-socrates'"
        val: "4.19.119-30.2"
      - exp: "stage == 'yt-bohr'"
        val: "4.19.119-30.2"
      - exp: "stage == 'yt-landau'"
        val: "4.19.119-30.2"
      - exp: "stage == 'yt-markov'"
        val: "4.19.119-30.2"
      - exp: "stage == 'yt-seneca'"
        val: "4.19.119-30.2"
      - exp: "stage == 'yt-vanga'"
        val: "4.19.119-30.2"
      - exp: "stage == 'yt-ofd-xdc'"
        val: "4.19.119-30.2"
      - exp: "stage == 'yt-locke'"
        val: "4.19.119-30.2"
      - exp: "stage == 'yt-arnold'"
        val: "4.19.119-30.2"
      - exp: "stage == 'yt-hahn'"
        val: "4.19.119-30.2"
      - exp: "stage == 'qloud'"
        val: "4.19.119-30.2"
      - exp: "stage == 'sandbox'"
        val: "4.19.119-30.2"
      - exp: "stage == 'yp-distbuild'"
        val: "5.4.112-15.3"
      - exp: "stage == 'distbuild'"
        val: "4.19.119-30.2"
      - exp: "stage == 'incoming'"
        val: "4.19.119-30.2"
      - exp: "stage == 'market'"
        val: "4.19.119-30.2"
      - exp: "stage == 'yabs'"
        val: "4.19.119-30.2"
      - exp: "stage == 'default'"
        val: "4.19.119-30.2"
  - name: conf-ver
    match:
      - exp: "default()"
        val: "1.0-8117297"
  - name: extra-ver
    match:
      - exp: "stage == 'yp-iss-vla-noclab'"
        val: "4.19.183-42"
      - exp: "default()"
        val: "<skip>"
---
meta:
  name: yandex-rtc-kernel
  version: "{ver}-{conf-ver}"
  kind: SystemService
  annotations:
    stage: "{stage}"
spec:
  packages:
    - name: linux-image-server
      version: "{ver}"
    - name: linux-tools
      version: "{ver}"
    - name: yandex-rtc-kernel-config
      version: "{conf-ver}"
    - name: "linux-image-extra-{ver}"
      version: "{extra-ver}"
  files:
    - path: /etc/systemd/system/yandex-rtc-kernel.service
      content: |+
        [Unit]
        Description=Yandex rtc config package
        Documentation=https://a.yandex-team.ru/arc/trunk/arcadia/infra/packages/kernel

        [Service]
        ExecStart=/usr/sbin/ya-salt --log-file /var/log/ya-salt-exec.log exec /var/lib/ya-salt/exec/kernel/kernel
        ExecStop=/bin/true
        RemainAfterExit=yes
        Type=oneshot

        [Install]
        WantedBy=multi-user.target
    - path: /var/lib/ya-salt/exec/kernel/kernel/hostctl.yaml
      content: |+
        version: "{ver}"
  update_policy:
    method: restart
    timeout: 600s
    retries: 1
`
	unitReader := bytes.NewReader([]byte(unitYaml))
	hi := &hostpb.HostInfo{
		Hostname:      "man1-8186.search.yandex.net",
		KernelRelease: "4.19.172-41",
		WalleProject:  "rtc-prestable",
		WalleTags: []string{
			"rtc",
			"rtc.automation-enabled",
			"rtc.cohabitation-enabled",
			"rtc.gpu-none",
			"rtc.reboot_segment-prestable-def",
			"rtc.scheduler-gencfg",
			"rtc.stage-prestable",
			"rtc_network",
			"runtime",
			"search",
			"skynet_installed",
			"tentacles_monitored",
			"yasm_monitored",
		},
	}
	renderer, err := render.NewWithTemplate(unitReader)
	assert.NoError(b, err)
	for i := 0; i < b.N; i++ {
		_, err := renderer.Render(hi)
		assert.NoError(b, err)
	}
}
