// Package rtcutil handles hostctl units rendering on rtc hosts/clusters.
package rtcutil

const (
	SAS       = "SAS"
	VLA       = "VLA"
	MAN       = "MAN"
	MSK       = "MSK"
	PRESTABLE = "PRESTABLE"
)

var (
	reporterAddrs = map[string]string{
		PRESTABLE: "hm-prestable.in.yandex.net:8999",
		SAS:       "hm-sas.in.yandex.net:8999",
		VLA:       "hm-vla.in.yandex.net:8999",
		MAN:       "hm-man.in.yandex.net:8999",
		MSK:       "hm-msk.in.yandex.net:8999",
	}
	rtcClusters = []string{SAS, VLA, MAN, MSK, PRESTABLE}
)

// BUG(warwish): package cannot render fragmented units.
// Broken functions marked as deprecated. Fix will be provided soon.

// GetClusterList returns list of pre-defined RTC clusters
func GetClusterList() []string {
	rv := make([]string, len(rtcClusters))
	copy(rv, rtcClusters)
	return rv
}
