// Package rtcutil contains RTC-specific rendering helpers, using real cluster data.
package rtcutil

import (
	"log"
	"os"
	"testing"

	"a.yandex-team.ru/infra/hostctl/pkg/render"
)

func ExampleClusterRenderer_Unit() {
	u, err := os.Open("unit.yaml")
	if err != nil {
		log.Fatalf("Cannot open unit.yaml: %v", err)
	}
	renderer, err := NewClusterRenderer("PRESTABLE")
	if err != nil {
		log.Fatalf("Cannot create renderer for cluster PRESTABLE: %v", err)
	}
	result, err := renderer.Unit(u)
	if err != nil {
		log.Fatalf("Cannot render unit.yaml on PRESTABLE clustre: %v", err)
	}
	result[0].Hosts()
}

func ExampleHostRenderer_UnitOn() {
	u, err := os.Open("unit.yaml")
	if err != nil {
		log.Fatalf("Cannot open unit.yaml: %v", err)
	}
	renderer, err := NewHostRendererForCluster("PRESTABLE")
	if err != nil {
		log.Fatalf("Cannot create renderer for cluster PRESTABLE: %v", err)
	}
	result, err := renderer.UnitOn(u, "sas1-4920.search.yandex.net")
	if err != nil {
		log.Fatalf("Cannot render unit.yaml on sas1-4920.search.yandex.net: %v", err)
	}
	result.Digest()
}

func ExampleClusterRenderer_UnitFromStorage() {
	s, err := render.NewLocalRenderStorage("unit.yaml")
	if err != nil {
		log.Fatalf("Cannot create render storage: %v", err)
	}
	unitName := render.UnitNameFromPath("unit.yaml")
	renderer, err := NewClusterRenderer("PRESTABLE")
	if err != nil {
		log.Fatalf("Cannot create renderer for cluster PRESTABLE: %v", err)
	}
	result, err := renderer.UnitFromStorage(s, unitName)
	if err != nil {
		log.Fatalf("Cannot render unit.yaml on PRESTABLE clustre: %v", err)
	}
	result[0].Hosts()
}

func ExampleHostRenderer_UnitFromStorage() {
	s, err := render.NewLocalRenderStorage("unit.yaml")
	if err != nil {
		log.Fatalf("Cannot create render storage: %v", err)
	}
	unitName := render.UnitNameFromPath("unit.yaml")
	renderer, err := NewHostRendererForCluster("PRESTABLE")
	if err != nil {
		log.Fatalf("Cannot create renderer for cluster PRESTABLE: %v", err)
	}
	result, err := renderer.UnitFromStorage(s, unitName, "sas1-4920.search.yandex.net")
	if err != nil {
		log.Fatalf("Cannot render unit.yaml on sas1-4920.search.yandex.net: %v", err)
	}
	result.Digest()
}

func TestGetClusterList(t *testing.T) {
	l := GetClusterList()
	if len(l) != 5 {
		t.Fatalf("there should be exaclty 5 clusters in RTC right now, got: %d", len(l))
	}
}
