package rtcutil

import (
	"fmt"
	"io"

	"a.yandex-team.ru/infra/hmserver/pkg/reporter/client"
	"a.yandex-team.ru/infra/hostctl/pkg/render"
	"a.yandex-team.ru/infra/hostctl/pkg/unitstorage"
	hostpb "a.yandex-team.ru/infra/hostctl/proto"
	"a.yandex-team.ru/library/go/slices"
)

type hostRendererClient interface {
	GetHost(string) (*hostpb.HostInfo, error)
}

// HostRenderer represents units renderer for hosts from RTC cluster.
type HostRenderer struct {
	client hostRendererClient
}

// NewHostRendererForCluster creates an instance of HostRenderer for specified cluster.
func NewHostRendererForCluster(c string) (*HostRenderer, error) {
	if ok, err := slices.Contains(rtcClusters, c); !ok || err != nil {
		return nil, fmt.Errorf("unknown rtc cluster %s: %w", c, err)
	}
	return &HostRenderer{
		client: client.NewReporter(reporterAddrs[c]),
	}, nil
}

// Deprecated: UnitOn renders given unit for host with given fqdn.
// UnitOn cannot handle fragmented units.
func (h *HostRenderer) UnitOn(u io.Reader, fqdn string) (*render.Result, error) {
	hi, err := h.client.GetHost(fqdn)
	if err != nil {
		return nil, err
	}
	rv, err := render.Unit(u, hi)
	if err != nil {
		return nil, err
	}
	return rv, nil
}

// UnitFromStorage renders given unit for host with given fqdn.
func (h *HostRenderer) UnitFromStorage(s unitstorage.Storage, name, fqdn string) (*render.Result, error) {
	hi, err := h.client.GetHost(fqdn)
	if err != nil {
		return nil, err
	}
	rv, err := render.UnitFromStorage(s, name, hi)
	if err != nil {
		return nil, err
	}
	return rv, nil
}
