package unitstorage

import (
	"io/fs"
	"os"
)

// LocalFS implements FS interface for local filesystem
// Please be careful working with errors: FS-base APIs assume that fs.* errors are used
// But os-based implementation returns os.* errors
// Please implement appreciate error mapping if you'll use some special error handling
type LocalFS struct {
}

// NewLocalFS constructs LocalFS instance
func NewLocalFS() FS {
	return &LocalFS{}
}

func (f *LocalFS) Open(name string) (fs.File, error) {
	open, err := os.Open(name)
	if err != nil {
		return nil, err
	}
	return open, nil
}

func (f *LocalFS) ReadDir(name string) ([]fs.DirEntry, error) {
	dir, err := os.ReadDir(name)
	if err != nil {
		return nil, err
	}
	return dir, nil
}

func (f *LocalFS) Stat(name string) (fs.FileInfo, error) {
	stat, err := os.Stat(name)
	if err != nil {
		return nil, err
	}
	return stat, nil
}
