package rpc

import (
	"a.yandex-team.ru/infra/hostctl/internal/reporting"
	"a.yandex-team.ru/infra/hostctl/internal/units"
	"a.yandex-team.ru/infra/hostctl/internal/units/env"
	"a.yandex-team.ru/infra/hostctl/internal/units/manager"
	"a.yandex-team.ru/infra/hostctl/internal/units/storage"
	"a.yandex-team.ru/infra/hostctl/internal/yamlutil"
	pb "a.yandex-team.ru/infra/hostctl/proto"
)

func modeName(req *pb.ManageRequest) string {
	switch req.ManageMode.(type) {
	case *pb.ManageRequest_All:
		return "all"
	case *pb.ManageRequest_Inline:
		return "inline"
	case *pb.ManageRequest_Targets:
		return "targets"
	default:
		return "<unknown>"
	}
}

func Manage(req *pb.ManageRequest) error {
	l, err := CreateLog(req.Verbose, req.Logfile)
	if err != nil {
		return err
	}
	marshaledReq, err := yamlutil.ProtoToYaml(req)
	if err != nil {
		return err
	}
	// Decorate first line to be able to navigate in text logs
	l.Infof("\n================ Started manage request (mode: %s) ================\n%s", modeName(req), marshaledReq)
	store := storage.NewReadonly("")
	if req.Storage == pb.StorageType_READWRITE {
		store = storage.New("")
	}
	var unitEnv *env.Env
	if req.JobEnv == pb.EnvType_NOOP {
		unitEnv = env.Noop(l)
	} else {
		unitEnv = env.Real(l, req.Orly.NoOrly, req.Orly.OrlyUrl, req.Info.Hostname)
	}
	var manageErr error
	opts := units.NewManageOpts(unitEnv, req.Info, store, req.OverrideDirs, req.RepoDir)
	switch r := req.ManageMode.(type) {
	case *pb.ManageRequest_Inline:
		manageErr = units.ManageInline(opts, r.Inline.Yaml)
	case *pb.ManageRequest_Targets:
		manageErr = units.ManageTargets(opts, manager.NewStrictTarget(r.Targets.TargetUnits))
	case *pb.ManageRequest_All:
		manageErr = units.ManageAll(opts)
	}
	reporting.Report((*reporting.ReportParams)(req.ReportParams), req.Info, unitEnv.L)
	return manageErr
}
