package rpc

import (
	"a.yandex-team.ru/infra/hostctl/internal/units"
	"a.yandex-team.ru/infra/hostctl/internal/units/env"
	"a.yandex-team.ru/infra/hostctl/internal/units/storage"
	"a.yandex-team.ru/infra/hostctl/internal/yamlutil"
	pb "a.yandex-team.ru/infra/hostctl/proto"
)

func Remove(req *pb.RemoveRequest) error {
	l, err := CreateLog(req.Verbose, req.Logfile)
	if err != nil {
		return err
	}
	marshaledReq, err := yamlutil.ProtoToYaml(req)
	if err != nil {
		return err
	}
	// Decorate first line to be able to navigate in text logs
	l.Infof("\n================ Started manage request ================\n%s", marshaledReq)
	e := env.Real(l, true, "", req.Info.Hostname)
	opts := units.NewRemoveOpts(e, req.Info, storage.New(""), req.Name)
	return units.Remove(opts)
}
