package rpc

import (
	"a.yandex-team.ru/infra/hostctl/internal/units/storage"
	pb "a.yandex-team.ru/infra/hostctl/proto"
)

type HostCtl struct {
}

func (h *HostCtl) Manage(req *pb.ManageRequest) (*pb.ManageResponse, error) {
	err := Manage(req)
	if err != nil {
		return nil, err
	}
	return &pb.ManageResponse{}, nil
}

func (h *HostCtl) Apply(req *pb.ApplyRequest) (*pb.ApplyResponse, error) {
	resp, err := Apply(req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (h *HostCtl) List(req *pb.ListRequest) (*pb.ListResponse, error) {
	state, err := storage.NewReadonly(req.StateFile).Load()
	if err != nil {
		return nil, err
	}
	return &pb.ListResponse{State: state}, nil
}

func (h *HostCtl) Report(req *pb.ReportRequest) (*pb.ReportResponse, error) {
	err := Report(req)
	if err != nil {
		return nil, err
	}
	return &pb.ReportResponse{}, nil
}

func (h *HostCtl) Remove(req *pb.RemoveRequest) (*pb.RemoveResponse, error) {
	err := Remove(req)
	if err != nil {
		return nil, err
	}
	return &pb.RemoveResponse{}, nil
}
