package main

import (
	"a.yandex-team.ru/infra/hostctl/internal/cmdutil"
	"a.yandex-team.ru/infra/hostctl/internal/slot"
	"a.yandex-team.ru/infra/hostctl/internal/term"
	"a.yandex-team.ru/infra/hostctl/internal/units/storage"
	"github.com/spf13/cobra"
	"log"
)

// Make different build target from hostctl to be safe from accidentally runs from main hostctl binary.
func main() {
	rootCmd := cmdutil.NewRoot("hostctl-patch", "Script for pathching hostctl state")
	// Get same lock as hostctl
	rootCmd.RegisterExclusiveCommand(Remove())
	if err := (*cobra.Command)(rootCmd).Execute(); err != nil {
		log.Fatal(err)
	}
}

func Remove() *cobra.Command {
	cmd := &cobra.Command{
		Use: "remove",
		Short: "!!!UNSAFE!!! Remove unit from state. " +
			"!!!Be sure that script was built with same proto that hostctl saves state!!!",
		Args: cobra.ExactArgs(1),
		Run: func(cmd *cobra.Command, args []string) {
			if len(args) != 1 {
				term.FatalF("%d args found, should be 1 (unit name)", len(args))
			}
			name := args[0]
			s := storage.New(storage.StateFile)
			// load current state
			state, err := s.Load()
			if err != nil {
				term.FatalE(err)
			}
			slots := slot.SlotsFromPb(state)
			// UNSAFE: remove unit from state
			delete(slots, name)
			// dump slots
			state.Slots = slot.HostCTLSlots(slots)
			// save
			if err := s.Save(state); err != nil {
				term.FatalE(err)
			}
		},
	}
	return cmd
}
