package units

import (
	"a.yandex-team.ru/infra/hostctl/internal/engine/definitions"
	"a.yandex-team.ru/infra/hostctl/internal/engine/template"
	pb "a.yandex-team.ru/infra/hostctl/proto"
	"testing"
)

var emptyHI = &pb.HostInfo{
	KernelRelease: "4.19.119-31.1",
}

func Test_SpecCompile(t *testing.T) {
	for _, name := range Names {
		t.Run(name, func(t *testing.T) {
			f, err := Dir.Open(name)
			if err != nil {
				t.Errorf("failed to open '%s%s': %s", Dir, name, err)
				return
			}
			tmpl, err := template.Parse(definitions.New(f, name))
			if err != nil {
				t.Fatal(err)
			}
			if _, err = tmpl.Render(emptyHI); err != nil {
				t.Errorf("failed to compile unit: %s", err)
			}
		})
	}
}
